package org.seasar.jsf.runtime;

import javax.servlet.jsp.tagext.Tag;

import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.SLinkedList;

/**
 * @author higa
 *
 */
public class TagPoolEntry {

	private Class tagClass;
	
	private SLinkedList pool = new SLinkedList();
	
	public TagPoolEntry(Class tagClass) {
		if (!Tag.class.isAssignableFrom(tagClass)) {
			throw new IllegalArgumentException(tagClass.toString());
		}
		this.tagClass = tagClass;
	}
	
	public synchronized Tag request() {
		if (!pool.isEmpty()) {
			return (Tag) pool.removeLast();
		}
		return (Tag) ClassUtil.newInstance(tagClass);
	}

	public synchronized void release(Tag tag) {
		pool.addLast(tag);
	}
}
