package org.seasar.jsf.selector;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.TagSelector;
import org.seasar.jsf.processor.CommandButtonProcessor;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class CommandButtonSelector implements TagSelector {

	public CommandButtonSelector() {
	}

	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		if (!JsfConstants.INPUT_ELEM.equalsIgnoreCase(qName)) {
			return false;
		}
		String type = attributes.getValue(JsfConstants.TYPE_ATTR);
		String action = attributes.getValue(JsfConstants.MAYA_NSURI,
				JsfConstants.ACTION_ATTR);
		return (JsfConstants.SUBMIT_VALUE.equalsIgnoreCase(type) || JsfConstants.BUTTON_VALUE
				.equalsIgnoreCase(type))
				&& action != null;
	}

	public TagProcessor createProcessor() {
		return new CommandButtonProcessor();
	}
}