package org.seasar.jsf.selector;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.TagSelector;
import org.seasar.jsf.processor.SelectOneMenuProcessor;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class SelectOneMenuSelector implements TagSelector {

	public SelectOneMenuSelector() {
	}

	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		if (!JsfConstants.SELECT_ELEM.equalsIgnoreCase(qName)) {
			return false;
		}
		return attributes.getValue(JsfConstants.MULTIPLE_ATTR) == null;
	}

	public TagProcessor createProcessor() {
		return new SelectOneMenuProcessor();
	}
}