package org.seasar.jsf.taglib;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.faces.component.UIComponent;
import javax.faces.webapp.UIComponentTag;

import org.seasar.jsf.component.UIElement;

/**
 * @author higa
 *  
 */
public class ElementTag extends UIComponentTag {

	private String tagName;

	private Map attributes = new HashMap();

	public ElementTag() {
	}

	/**
	 * @return Returns the tagName.
	 */
	public String getTagName() {
		return tagName;
	}

	/**
	 * @param tagName
	 *            The tagName to set.
	 */
	public void setTagName(String tagName) {
		this.tagName = tagName;
	}

	public void addAttribute(String name, String value) {
		attributes.put(name, value);
	}

	public String getComponentType() {
		return UIElement.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return UIElement.DEFAULT_RENDERER_TYPE;
	}

	/**
	 * @see javax.faces.webapp.UIComponentTag#setProperties(javax.faces.component.UIComponent)
	 */
	protected void setProperties(UIComponent component) {
		super.setProperties(component);
		UIElement elem = (UIElement) component;
		elem.setTagName(tagName);
		for (Iterator i = attributes.keySet().iterator(); i.hasNext();) {
			String name = (String) i.next();
			String value = (String) attributes.get(name);
			elem.setAttribute(name, value);
		}
	}

	/**
	 * @see javax.servlet.jsp.tagext.Tag#release()
	 */
	public void release() {
		super.release();
		tagName = null;
		attributes.clear();
	}
}