package org.seasar.jsf.taglib;

import javax.faces.component.UIComponent;

import org.seasar.jsf.component.Invoke;

/**
 * @author higa
 *  
 */
public class InvokeTag extends UIComponentTagBase {

	private String action;
	
	public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public String getComponentType() {
		return Invoke.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return Invoke.DEFAULT_RENDERER_TYPE;
	}
	
	public void release() {
		super.release();
		action = null;
	}

	protected void setProperties(UIComponent component) {
		super.setProperties(component);
		setActionProperty(component, action);
	}
}