/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.core.AbstractClassGenerator;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.ClassInfo;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.CollectionUtils;
import net.sf.cglib.core.DuplicatesPredicate;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.KeyFactory;
import net.sf.cglib.core.Local;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.MethodInfoTransformer;
import net.sf.cglib.core.MethodWrapper;
import net.sf.cglib.core.ObjectSwitchCallback;
import net.sf.cglib.core.ProcessSwitchCallback;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.RejectModifierPredicate;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.Transformer;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.core.VisibilityPredicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.CallbackFilter2;
import net.sf.cglib.proxy.CallbackGenerator;
import net.sf.cglib.proxy.CallbackInfo;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.transform.ClassEmitterTransformer;
import net.sf.cglib.transform.ClassTransformer;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class Enhancer
extends AbstractClassGenerator {
    private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source((class$net$sf$cglib$proxy$Enhancer == null ? (class$net$sf$cglib$proxy$Enhancer = Enhancer.class$("net.sf.cglib.proxy.Enhancer")) : class$net$sf$cglib$proxy$Enhancer).getName());
    private static final EnhancerKey KEY_FACTORY = (EnhancerKey)((Object)KeyFactory.create(class$net$sf$cglib$proxy$Enhancer$EnhancerKey == null ? (class$net$sf$cglib$proxy$Enhancer$EnhancerKey = Enhancer.class$("net.sf.cglib.proxy.Enhancer$EnhancerKey")) : class$net$sf$cglib$proxy$Enhancer$EnhancerKey, KeyFactory.CLASS_BY_NAME));
    private static final String BOUND_FIELD = "CGLIB$BOUND";
    private static final String THREAD_CALLBACKS_FIELD = "CGLIB$THREAD_CALLBACKS";
    private static final String DEFAULT_CALLBACKS_FIELD = "CGLIB$DEFAULT_CALLBACKS";
    private static final String SET_THREAD_CALLBACKS_NAME = "CGLIB$SET_THREAD_CALLBACKS";
    private static final String SET_DEFAULT_CALLBACKS_NAME = "CGLIB$SET_DEFAULT_CALLBACKS";
    private static final Type FACTORY = TypeUtils.parseType("net.sf.cglib.proxy.Factory");
    private static final Type ILLEGAL_STATE_EXCEPTION = TypeUtils.parseType("IllegalStateException");
    private static final Type ILLEGAL_ARGUMENT_EXCEPTION = TypeUtils.parseType("IllegalArgumentException");
    private static final Type THREAD_LOCAL = TypeUtils.parseType("ThreadLocal");
    private static final Type CALLBACK = TypeUtils.parseType("net.sf.cglib.proxy.Callback");
    private static final Type CALLBACK_ARRAY = TypeUtils.parseType("net.sf.cglib.proxy.Callback[]");
    private static final Signature CSTRUCT_NULL = TypeUtils.parseConstructor("");
    private static final Signature SET_THREAD_CALLBACKS = new Signature("CGLIB$SET_THREAD_CALLBACKS", Type.VOID_TYPE, new Type[]{CALLBACK_ARRAY});
    private static final Signature SET_DEFAULT_CALLBACKS = new Signature("CGLIB$SET_DEFAULT_CALLBACKS", Type.VOID_TYPE, new Type[]{CALLBACK_ARRAY});
    private static final Signature NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance(net.sf.cglib.proxy.Callback[])");
    private static final Signature MULTIARG_NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance(Class[], Object[], net.sf.cglib.proxy.Callback[])");
    private static final Signature SINGLE_NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance(net.sf.cglib.proxy.Callback)");
    private static final Signature SET_CALLBACK = TypeUtils.parseSignature("void setCallback(int, net.sf.cglib.proxy.Callback)");
    private static final Signature GET_CALLBACK = TypeUtils.parseSignature("net.sf.cglib.proxy.Callback getCallback(int)");
    private static final Signature SET_CALLBACKS = TypeUtils.parseSignature("void setCallbacks(net.sf.cglib.proxy.Callback[])");
    private static final Signature GET_CALLBACKS = TypeUtils.parseSignature("net.sf.cglib.proxy.Callback[] getCallbacks()");
    private static final Signature THREAD_LOCAL_GET = TypeUtils.parseSignature("Object get()");
    private static final Signature THREAD_LOCAL_SET = TypeUtils.parseSignature("void set(Object)");
    private static final Signature BIND_CALLBACKS = TypeUtils.parseSignature("void CGLIB$BIND_CALLBACKS(Object)");
    private Class[] interfaces;
    private Object filter;
    private Callback[] callbacks;
    private Type[] callbackTypes;
    private boolean classOnly;
    private Class superclass;
    private Class[] argumentTypes;
    private Object[] arguments;
    private boolean useFactory = true;
    private int depth;
    static /* synthetic */ Class class$net$sf$cglib$proxy$Enhancer;
    static /* synthetic */ Class class$net$sf$cglib$proxy$Enhancer$EnhancerKey;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$cglib$proxy$Factory;
    static /* synthetic */ Class array$Lnet$sf$cglib$proxy$Callback;

    public Enhancer() {
        super(SOURCE);
    }

    public void setSuperclass(Class superclass) {
        if (superclass != null && superclass.isInterface()) {
            this.setInterfaces(new Class[]{superclass});
        } else {
            this.superclass = superclass != null && superclass.equals(class$java$lang$Object == null ? (class$java$lang$Object = Enhancer.class$("java.lang.Object")) : class$java$lang$Object) ? null : superclass;
        }
    }

    public void setInterfaces(Class[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setCallbackFilter(CallbackFilter filter) {
        this.filter = filter;
    }

    public void setCallbackFilter2(CallbackFilter2 filter) {
        this.filter = filter;
    }

    public void setCallback(Callback callback) {
        this.setCallbacks(new Callback[]{callback});
    }

    public void setCallbacks(Callback[] callbacks) {
        if (callbacks != null && callbacks.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty");
        }
        this.callbacks = callbacks;
    }

    public void setUseFactory(boolean useFactory) {
        this.useFactory = useFactory;
    }

    public void setCallbackType(Class callbackType) {
        this.setCallbackTypes(new Class[]{callbackType});
    }

    public void setCallbackTypes(Class[] callbackTypes) {
        if (callbackTypes != null && callbackTypes.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty");
        }
        this.callbackTypes = CallbackInfo.determineTypes(callbackTypes);
    }

    public Object create() {
        this.classOnly = false;
        this.argumentTypes = null;
        return this.createHelper();
    }

    public Object create(Class[] argumentTypes, Object[] arguments) {
        this.classOnly = false;
        if (argumentTypes == null || arguments == null || argumentTypes.length != arguments.length) {
            throw new IllegalArgumentException("Arguments must be non-null and of equal length");
        }
        this.argumentTypes = argumentTypes;
        this.arguments = arguments;
        return this.createHelper();
    }

    public Class createClass() {
        this.classOnly = true;
        return (Class)this.createHelper();
    }

    private void validate(boolean transforming) {
        if (transforming && this.filter != null && !(this.filter instanceof CallbackFilter2)) {
            throw new IllegalStateException("CallbackFilter2 must be used when transforming");
        }
        if ((this.classOnly || transforming) ^ this.callbacks == null) {
            if (this.classOnly || transforming) {
                throw new IllegalStateException("createClass and createTransformer do not accept callbacks");
            }
            throw new IllegalStateException("Callbacks are required");
        }
        if ((this.classOnly || transforming) && this.callbackTypes == null) {
            throw new IllegalStateException("Callback types are required");
        }
        if (this.callbacks != null && this.callbackTypes != null) {
            if (this.callbacks.length != this.callbackTypes.length) {
                throw new IllegalStateException("Lengths of callback and callback types array must be the same");
            }
            Type[] check = CallbackInfo.determineTypes(this.callbacks);
            for (int i = 0; i < check.length; ++i) {
                if (check[i].equals((Object)this.callbackTypes[i])) continue;
                throw new IllegalStateException("Callback " + check[i] + " is not assignable to " + this.callbackTypes[i]);
            }
        } else if (this.callbacks != null) {
            this.callbackTypes = CallbackInfo.determineTypes(this.callbacks);
        }
        if (this.filter == null) {
            if (this.callbackTypes.length > 1) {
                throw new IllegalStateException("Multiple callback types possible but no filter specified");
            }
            this.filter = CallbackFilter2.ALL_ZERO;
        }
        if (this.interfaces != null) {
            for (int i = 0; i < this.interfaces.length; ++i) {
                if (this.interfaces[i] == null) {
                    throw new IllegalStateException("Interfaces cannot be null");
                }
                if (this.interfaces[i].isInterface()) continue;
                throw new IllegalStateException(this.interfaces[i] + " is not an interface");
            }
        }
    }

    private Object createHelper() {
        this.validate(false);
        if (this.superclass != null) {
            this.setNamePrefix(this.superclass.getName());
        } else if (this.interfaces != null) {
            this.setNamePrefix(this.interfaces[ReflectUtils.findPackageProtected(this.interfaces)].getName());
        }
        Object key = KEY_FACTORY.newInstance(this.superclass, this.interfaces, this.filter, this.callbackTypes, this.useFactory);
        return super.create(key);
    }

    protected ClassLoader getDefaultClassLoader() {
        if (this.superclass != null) {
            return this.superclass.getClassLoader();
        }
        if (this.interfaces != null) {
            return this.interfaces[0].getClassLoader();
        }
        return null;
    }

    private Signature rename(Signature sig, int index) {
        return new Signature("CGLIB$" + sig.getName() + "$" + this.depth + "$" + index, sig.getDescriptor());
    }

    public ClassTransformer createTransformer() {
        this.validate(true);
        return new EnhancerTransformer();
    }

    static void getMethods(Class superclass, Class[] interfaces, List methods) {
        Enhancer.getMethods(superclass, interfaces, methods, null, null);
    }

    private static void getMethods(Class superclass, Class[] interfaces, List methods, List interfaceMethods, Set forcePublic) {
        List target;
        ReflectUtils.addAllMethods(superclass, methods);
        List list = target = interfaceMethods != null ? interfaceMethods : methods;
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                if (interfaces[i] == (class$net$sf$cglib$proxy$Factory == null ? Enhancer.class$("net.sf.cglib.proxy.Factory") : class$net$sf$cglib$proxy$Factory)) continue;
                ReflectUtils.addAllMethods(interfaces[i], target);
            }
        }
        if (interfaceMethods != null) {
            if (forcePublic != null) {
                forcePublic.addAll(MethodWrapper.createSet(interfaceMethods));
            }
            methods.addAll(interfaceMethods);
        }
        CollectionUtils.filter(methods, new RejectModifierPredicate(8));
        CollectionUtils.filter(methods, new VisibilityPredicate(superclass, true));
        CollectionUtils.filter(methods, new DuplicatesPredicate());
        CollectionUtils.filter(methods, new RejectModifierPredicate(16));
    }

    public void generateClass(ClassVisitor v) throws Exception {
        Class sc;
        Class clazz = this.superclass == null ? (class$java$lang$Object == null ? (class$java$lang$Object = Enhancer.class$("java.lang.Object")) : class$java$lang$Object) : (sc = this.superclass);
        if (TypeUtils.isFinal(sc.getModifiers())) {
            throw new IllegalArgumentException("Cannot subclass final class " + sc);
        }
        this.depth = Enhancer.calculateDepth(sc);
        ArrayList constructors = new ArrayList(Arrays.asList(sc.getDeclaredConstructors()));
        CollectionUtils.filter(constructors, new VisibilityPredicate(sc, true));
        if (constructors.size() == 0) {
            throw new IllegalArgumentException("No visible constructors in " + sc);
        }
        ClassEmitter e = new ClassEmitter(v);
        e.begin_class(1, this.getClassName(), Type.getType((Class)sc), this.useFactory ? TypeUtils.add(TypeUtils.getTypes(this.interfaces), FACTORY) : TypeUtils.getTypes(this.interfaces), "<generated>");
        ArrayList actualMethods = new ArrayList();
        ArrayList interfaceMethods = new ArrayList();
        final HashSet forcePublic = new HashSet();
        Enhancer.getMethods(sc, this.interfaces, actualMethods, interfaceMethods, forcePublic);
        List methods = CollectionUtils.transform(actualMethods, new Transformer(){

            public Object transform(Object value) {
                Method method = (Method)value;
                int modifiers = 0x10 | method.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF & 0xFFFFFFDF;
                if (forcePublic.contains(MethodWrapper.create(method))) {
                    modifiers = modifiers & 0xFFFFFFFB | 1;
                }
                return ReflectUtils.getMethodInfo(method, modifiers);
            }
        });
        this.emit(e, false, CollectionUtils.transform(constructors, MethodInfoTransformer.getInstance()), methods, actualMethods);
        e.end_class();
    }

    protected Object firstInstance(Class type) throws Exception {
        if (this.classOnly) {
            return type;
        }
        return this.createUsingReflection(type);
    }

    protected Object nextInstance(Object instance) {
        Class<?> protoclass;
        Class<?> clazz = protoclass = instance instanceof Class ? (Class<?>)instance : instance.getClass();
        if (this.classOnly) {
            return protoclass;
        }
        if (instance instanceof Factory) {
            if (this.argumentTypes != null) {
                return ((Factory)instance).newInstance(this.argumentTypes, this.arguments, this.callbacks);
            }
            return ((Factory)instance).newInstance(this.callbacks);
        }
        return this.createUsingReflection(protoclass);
    }

    public static void registerCallbacks(Class generatedClass, Callback[] callbacks) {
        Enhancer.setDefaultCallbacks(generatedClass, callbacks);
        Enhancer.setThreadCallbacks(generatedClass, callbacks);
    }

    public static boolean isEnhanced(Class type) {
        try {
            Enhancer.getCallbacksSetter(type, SET_THREAD_CALLBACKS_NAME);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static void setThreadCallbacks(Class type, Callback[] callbacks) {
        Enhancer.setCallbacksHelper(type, callbacks, SET_THREAD_CALLBACKS_NAME);
    }

    private static void setDefaultCallbacks(Class type, Callback[] callbacks) {
        Enhancer.setCallbacksHelper(type, callbacks, SET_DEFAULT_CALLBACKS_NAME);
    }

    private static void setCallbacksHelper(Class type, Callback[] callbacks, String methodName) {
        try {
            Method setter = Enhancer.getCallbacksSetter(type, methodName);
            setter.invoke(null, new Object[]{callbacks});
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(type + " is not an enhanced class");
        }
        catch (IllegalAccessException e) {
            throw new CodeGenerationException(e);
        }
        catch (InvocationTargetException e) {
            throw new CodeGenerationException(e);
        }
    }

    private static Method getCallbacksSetter(Class type, String methodName) throws NoSuchMethodException {
        return type.getDeclaredMethod(methodName, array$Lnet$sf$cglib$proxy$Callback == null ? (array$Lnet$sf$cglib$proxy$Callback = Enhancer.class$("[Lnet.sf.cglib.proxy.Callback;")) : array$Lnet$sf$cglib$proxy$Callback);
    }

    private Object createUsingReflection(Class type) {
        Enhancer.setThreadCallbacks(type, this.callbacks);
        if (this.argumentTypes != null) {
            return ReflectUtils.newInstance(type, this.argumentTypes, this.arguments);
        }
        return ReflectUtils.newInstance(type);
    }

    public static Object create(Class type, Callback callback) {
        Enhancer e = new Enhancer();
        e.setSuperclass(type);
        e.setCallback(callback);
        return e.create();
    }

    public static Object create(Class superclass, Class[] interfaces, Callback callback) {
        Enhancer e = new Enhancer();
        e.setSuperclass(superclass);
        e.setInterfaces(interfaces);
        e.setCallback(callback);
        return e.create();
    }

    public static Object create(Class superclass, Class[] interfaces, CallbackFilter filter, Callback[] callbacks) {
        Enhancer e = new Enhancer();
        e.setSuperclass(superclass);
        e.setInterfaces(interfaces);
        e.setCallbackFilter(filter);
        e.setCallbacks(callbacks);
        return e.create();
    }

    private static boolean isExcluded(Type superType) {
        String desc = superType.getDescriptor();
        return desc.equals("Lnet/sf/cglib/reflect/FastClass;") || desc.equals("Lnet/sf/cglib/core/KeyFactory;");
    }

    public void emit(ClassEmitter ce, boolean transforming, List constructors, List methods, List actualMethods) {
        ce.declare_field(2, BOUND_FIELD, Type.BOOLEAN_TYPE, null, null);
        ce.declare_field(26, THREAD_CALLBACKS_FIELD, THREAD_LOCAL, null, null);
        ce.declare_field(10, DEFAULT_CALLBACKS_FIELD, CALLBACK_ARRAY, null, null);
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            ce.declare_field(2, Enhancer.getCallbackField(i), this.callbackTypes[i], null, null);
        }
        this.emitMethods(ce, transforming, methods, actualMethods);
        if (!transforming) {
            this.emitConstructors(ce, constructors);
        }
        this.emitSetDefaultCallbacks(ce);
        this.emitSetThreadCallbacks(ce);
        this.emitBindCallbacks(ce);
        if (this.useFactory) {
            int[] keys = this.getCallbackKeys();
            this.emitNewInstanceCallbacks(ce);
            this.emitNewInstanceCallback(ce);
            this.emitNewInstanceMultiarg(ce, constructors);
            this.emitGetCallback(ce, keys);
            this.emitSetCallback(ce, keys);
            this.emitGetCallbacks(ce);
            this.emitSetCallbacks(ce);
        }
    }

    private void emitConstructors(ClassEmitter ce, List constructors) {
        boolean seenNull = false;
        Iterator it = constructors.iterator();
        while (it.hasNext()) {
            MethodInfo constructor = (MethodInfo)it.next();
            CodeEmitter e = EmitUtils.begin_method(ce, constructor, 1);
            e.load_this();
            e.dup();
            e.load_args();
            Signature sig = constructor.getSignature();
            seenNull = seenNull || sig.getDescriptor().equals("()V");
            e.super_invoke_constructor(sig);
            e.invoke_static_this(BIND_CALLBACKS);
            e.return_value();
            e.end_method();
        }
        if (!this.classOnly && !seenNull && this.arguments == null) {
            throw new IllegalArgumentException("Superclass has no null constructors but no arguments were given");
        }
    }

    private int[] getCallbackKeys() {
        int[] keys = new int[this.callbackTypes.length];
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            keys[i] = i;
        }
        return keys;
    }

    private void emitGetCallback(ClassEmitter ce, int[] keys) {
        final CodeEmitter e = ce.begin_method(1, GET_CALLBACK, null, null);
        e.load_this();
        e.invoke_static_this(BIND_CALLBACKS);
        e.load_this();
        e.load_arg(0);
        e.process_switch(keys, new ProcessSwitchCallback(){

            public void processCase(int key, Label end) {
                e.getfield(Enhancer.getCallbackField(key));
                e.goTo(end);
            }

            public void processDefault() {
                e.pop();
                e.aconst_null();
            }
        });
        e.return_value();
        e.end_method();
    }

    private void emitSetCallback(ClassEmitter ce, int[] keys) {
        final CodeEmitter e = ce.begin_method(1, SET_CALLBACK, null, null);
        e.load_this();
        e.load_arg(1);
        e.load_arg(0);
        e.process_switch(keys, new ProcessSwitchCallback(){

            public void processCase(int key, Label end) {
                e.checkcast(Enhancer.this.callbackTypes[key]);
                e.putfield(Enhancer.getCallbackField(key));
                e.goTo(end);
            }

            public void processDefault() {
                e.pop2();
            }
        });
        e.return_value();
        e.end_method();
    }

    private void emitSetCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(1, SET_CALLBACKS, null, null);
        e.load_this();
        e.load_arg(0);
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            e.dup2();
            e.aaload(i);
            e.checkcast(this.callbackTypes[i]);
            e.putfield(Enhancer.getCallbackField(i));
        }
        e.return_value();
        e.end_method();
    }

    private void emitGetCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(1, GET_CALLBACKS, null, null);
        e.load_this();
        e.invoke_static_this(BIND_CALLBACKS);
        e.load_this();
        e.push(this.callbackTypes.length);
        e.newarray(CALLBACK);
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            e.dup();
            e.push(i);
            e.load_this();
            e.getfield(Enhancer.getCallbackField(i));
            e.aastore();
        }
        e.return_value();
        e.end_method();
    }

    private void emitNewInstanceCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(1, NEW_INSTANCE, null, null);
        e.load_arg(0);
        e.invoke_static_this(SET_THREAD_CALLBACKS);
        this.emitCommonNewInstance(e);
    }

    private void emitCommonNewInstance(CodeEmitter e) {
        e.new_instance_this();
        e.dup();
        e.invoke_constructor_this();
        e.return_value();
        e.end_method();
    }

    private void emitNewInstanceCallback(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(1, SINGLE_NEW_INSTANCE, null, null);
        switch (this.callbackTypes.length) {
            case 0: {
                break;
            }
            case 1: {
                e.push(1);
                e.newarray(CALLBACK);
                e.dup();
                e.push(0);
                e.load_arg(0);
                e.aastore();
                e.invoke_static_this(SET_THREAD_CALLBACKS);
                break;
            }
            default: {
                e.throw_exception(ILLEGAL_STATE_EXCEPTION, "More than one callback object required");
            }
        }
        this.emitCommonNewInstance(e);
    }

    private void emitNewInstanceMultiarg(ClassEmitter ce, List constructors) {
        final CodeEmitter e = ce.begin_method(1, MULTIARG_NEW_INSTANCE, null, null);
        e.load_arg(2);
        e.invoke_static_this(SET_THREAD_CALLBACKS);
        e.new_instance_this();
        e.dup();
        e.load_arg(0);
        EmitUtils.constructor_switch(e, constructors, new ObjectSwitchCallback(){

            public void processCase(Object key, Label end) {
                MethodInfo constructor = (MethodInfo)key;
                Type[] types = constructor.getSignature().getArgumentTypes();
                for (int i = 0; i < types.length; ++i) {
                    e.load_arg(1);
                    e.push(i);
                    e.aaload();
                    e.unbox(types[i]);
                }
                e.invoke_constructor_this(constructor.getSignature());
                e.goTo(end);
            }

            public void processDefault() {
                e.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Constructor not found");
            }
        });
        e.return_value();
        e.end_method();
    }

    private void emitMethods(ClassEmitter ce, final boolean transforming, List methods, List actualMethods) {
        Iterator it2;
        boolean isFilter2 = this.filter instanceof CallbackFilter2;
        CallbackGenerator[] generators = CallbackInfo.getGenerators(this.callbackTypes);
        HashMap<CallbackGenerator, ArrayList<MethodInfo>> groups = new HashMap<CallbackGenerator, ArrayList<MethodInfo>>();
        final HashMap<MethodInfo, Integer> indexes = new HashMap<MethodInfo, Integer>();
        final HashMap<MethodInfo, Integer> originalModifiers = new HashMap<MethodInfo, Integer>();
        final Map positions = CollectionUtils.getIndexMap(methods);
        Iterator it1 = methods.iterator();
        Iterator iterator = it2 = actualMethods != null ? actualMethods.iterator() : null;
        while (it1.hasNext()) {
            MethodInfo method = (MethodInfo)it1.next();
            Method actualMethod = it2 != null ? (Method)it2.next() : null;
            int index = isFilter2 ? ((CallbackFilter2)this.filter).accept(method) : ((CallbackFilter)this.filter).accept(actualMethod);
            if (index >= this.callbackTypes.length) {
                throw new IllegalArgumentException("Callback filter returned an index that is too large: " + index);
            }
            originalModifiers.put(method, new Integer(actualMethod != null ? actualMethod.getModifiers() : method.getModifiers()));
            indexes.put(method, new Integer(index));
            ArrayList<MethodInfo> group = (ArrayList<MethodInfo>)groups.get(generators[index]);
            if (group == null) {
                group = new ArrayList<MethodInfo>(methods.size());
                groups.put(generators[index], group);
            }
            group.add(method);
        }
        HashSet<CallbackGenerator> seenGen = new HashSet<CallbackGenerator>();
        CodeEmitter e = ce.getStaticHook();
        e.new_instance(THREAD_LOCAL);
        e.dup();
        e.invoke_constructor(THREAD_LOCAL, CSTRUCT_NULL);
        e.putfield(THREAD_CALLBACKS_FIELD);
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            CallbackGenerator gen = generators[i];
            if (seenGen.contains(gen)) continue;
            seenGen.add(gen);
            final List fmethods = (List)groups.get(gen);
            if (fmethods == null) continue;
            CallbackGenerator.Context context = new CallbackGenerator.Context(){

                public int getOriginalModifiers(MethodInfo method) {
                    return (Integer)originalModifiers.get(method);
                }

                public boolean isTransforming() {
                    return transforming;
                }

                public Iterator getMethods() {
                    return fmethods.iterator();
                }

                public int getIndex(MethodInfo method) {
                    return (Integer)indexes.get(method);
                }

                public void emitCallback(CodeEmitter e, int index) {
                    Enhancer.this.emitCurrentCallback(e, index);
                }

                public Signature getImplSignature(MethodInfo method) {
                    return Enhancer.this.rename(method.getSignature(), (Integer)positions.get(method));
                }
            };
            try {
                gen.generate(ce, context);
                gen.generateStatic(e, context);
                continue;
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (Exception x) {
                throw new CodeGenerationException(x);
            }
        }
        e.return_value();
        e.end_method();
    }

    private void emitSetThreadCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(9, SET_THREAD_CALLBACKS, null, null);
        e.getfield(THREAD_CALLBACKS_FIELD);
        e.load_arg(0);
        e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
        e.return_value();
        e.end_method();
    }

    private void emitSetDefaultCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(9, SET_DEFAULT_CALLBACKS, null, null);
        e.load_arg(0);
        e.putfield(DEFAULT_CALLBACKS_FIELD);
        e.return_value();
        e.end_method();
    }

    private void emitCurrentCallback(CodeEmitter e, int index) {
        e.load_this();
        e.getfield(Enhancer.getCallbackField(index));
        e.dup();
        Label end = e.make_label();
        e.ifnonnull(end);
        e.pop();
        e.load_this();
        e.invoke_static_this(BIND_CALLBACKS);
        e.load_this();
        e.getfield(Enhancer.getCallbackField(index));
        e.mark(end);
    }

    private void emitBindCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(26, BIND_CALLBACKS, null, null);
        Local me = e.make_local();
        e.load_arg(0);
        e.checkcast_this();
        e.store_local(me);
        Label end = e.make_label();
        e.load_local(me);
        e.getfield(BOUND_FIELD);
        e.if_jump(154, end);
        e.load_local(me);
        e.push(1);
        e.putfield(BOUND_FIELD);
        e.getfield(THREAD_CALLBACKS_FIELD);
        e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_GET);
        e.dup();
        Label found_callback = e.make_label();
        e.ifnonnull(found_callback);
        e.pop();
        e.getfield(DEFAULT_CALLBACKS_FIELD);
        e.dup();
        e.ifnonnull(found_callback);
        Label clear = e.make_label();
        e.pop();
        e.goTo(clear);
        e.mark(found_callback);
        e.checkcast(CALLBACK_ARRAY);
        e.load_local(me);
        e.swap();
        for (int i = this.callbackTypes.length - 1; i >= 0; --i) {
            if (i != 0) {
                e.dup2();
            }
            e.aaload(i);
            e.checkcast(this.callbackTypes[i]);
            e.putfield(Enhancer.getCallbackField(i));
        }
        e.mark(clear);
        e.getfield(THREAD_CALLBACKS_FIELD);
        e.aconst_null();
        e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
        e.mark(end);
        e.return_value();
        e.end_method();
    }

    private static String getCallbackField(int index) {
        return "CGLIB$CALLBACK_" + index;
    }

    private static int calculateDepth(Class type) {
        int depth = 0;
        while (type != null) {
            if (Enhancer.isEnhanced(type)) {
                ++depth;
            }
            type = type.getSuperclass();
        }
        return depth;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ Signature access$700() {
        return BIND_CALLBACKS;
    }

    private class EnhancerTransformer
    extends ClassEmitterTransformer {
        private ClassInfo classInfo;
        private List constructors;
        private List methods;
        private boolean collect;

        private EnhancerTransformer() {
        }

        /*
         * WARNING - void declaration
         */
        public void begin_class(int access, String className, Type superType, Type[] interfaces, String sourceFile) {
            Type[] useInterfaces = interfaces;
            if (TypeUtils.isInterface(access) || Enhancer.isExcluded(superType)) {
                this.collect = false;
            } else {
                void var8_8;
                Class superclass;
                this.collect = true;
                Type type = TypeUtils.getType(className);
                this.classInfo = new ClassInfo(this, type, superType, interfaces, access){
                    private final /* synthetic */ Type val$type;
                    private final /* synthetic */ Type val$superType;
                    private final /* synthetic */ Type[] val$interfaces;
                    private final /* synthetic */ int val$access;
                    private final /* synthetic */ EnhancerTransformer this$1;
                    {
                        this.this$1 = this$1;
                        this.val$type = val$type;
                        this.val$superType = val$superType;
                        this.val$interfaces = val$interfaces;
                        this.val$access = val$access;
                    }

                    public Type getType() {
                        return this.val$type;
                    }

                    public Type getSuperType() {
                        return this.val$superType;
                    }

                    public Type[] getInterfaces() {
                        return this.val$interfaces;
                    }

                    public int getModifiers() {
                        return this.val$access;
                    }
                };
                if (superType == null) {
                    superclass = class$java$lang$Object == null ? (class$java$lang$Object = Enhancer.class$("java.lang.Object")) : class$java$lang$Object;
                } else {
                    try {
                        superclass = Enhancer.this.getClassLoader().loadClass(superType.getClassName());
                    }
                    catch (ClassNotFoundException e) {
                        throw new CodeGenerationException(e);
                    }
                }
                Enhancer.this.depth = Enhancer.calculateDepth((Class)var8_8);
                ArrayList superMethods = new ArrayList();
                ReflectUtils.addAllMethods((Class)var8_8, superMethods);
                CollectionUtils.filter(superMethods, new RejectModifierPredicate(10));
                this.methods = CollectionUtils.transform(superMethods, MethodInfoTransformer.getInstance());
                this.methods = new ArrayList();
                this.constructors = new ArrayList();
                if (Enhancer.this.useFactory) {
                    useInterfaces = TypeUtils.add(interfaces, FACTORY);
                }
            }
            super.begin_class(access, className, superType, useInterfaces, sourceFile);
        }

        public CodeEmitter begin_method(int access, Signature sig, Type[] exceptions, Attribute attrs) {
            if (this.collect) {
                MethodInfo method = new MethodInfo(this, access, sig, exceptions, attrs){
                    private final /* synthetic */ int val$access;
                    private final /* synthetic */ Signature val$sig;
                    private final /* synthetic */ Type[] val$exceptions;
                    private final /* synthetic */ Attribute val$attrs;
                    private final /* synthetic */ EnhancerTransformer this$1;
                    {
                        this.this$1 = this$1;
                        this.val$access = val$access;
                        this.val$sig = val$sig;
                        this.val$exceptions = val$exceptions;
                        this.val$attrs = val$attrs;
                    }

                    public ClassInfo getClassInfo() {
                        return EnhancerTransformer.access$600(this.this$1);
                    }

                    public int getModifiers() {
                        return this.val$access;
                    }

                    public Signature getSignature() {
                        return this.val$sig;
                    }

                    public Type[] getExceptionTypes() {
                        return this.val$exceptions;
                    }

                    public Attribute getAttribute() {
                        return this.val$attrs;
                    }
                };
                if (TypeUtils.isConstructor(method)) {
                    this.constructors.add(method);
                    return new CodeEmitter(this, super.begin_method(access, sig, exceptions, attrs)){
                        private final /* synthetic */ EnhancerTransformer this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                            super.visitMethodInsn(opcode, owner, name, desc);
                            if (opcode == 183 && "<init>".equals(name)) {
                                this.load_this();
                                this.invoke_static_this(Enhancer.access$700());
                            }
                        }
                    };
                }
                if (!TypeUtils.isPrivate(access) && !TypeUtils.isStatic(access)) {
                    this.methods.add(method);
                    return super.begin_method(16, Enhancer.this.rename(sig, this.methods.size() - 1), exceptions, attrs);
                }
            }
            return super.begin_method(access, sig, exceptions, attrs);
        }

        public void end_class() {
            if (this.collect) {
                this.collect = false;
                Enhancer.this.emit(this, true, this.constructors, this.methods, null);
            }
            super.end_class();
        }

        static /* synthetic */ ClassInfo access$600(EnhancerTransformer x0) {
            return x0.classInfo;
        }
    }

    public static interface EnhancerKey {
        public Object newInstance(Class var1, Class[] var2, Object var3, Type[] var4, boolean var5);
    }
}

