/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.beans.impl;

import java.lang.reflect.Method;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.IllegalPropertyRuntimeException;
import org.seasar.framework.beans.MethodNotFoundRuntimeException;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.impl.PropertyDescImpl;
import org.seasar.framework.util.MethodUtil;
import org.seasar.struts.beans.IndexedPropertyDesc;

public class IndexedPropertyDescImpl
implements IndexedPropertyDesc {
    private String propertyName;
    private Class propertyType;
    private BeanDesc beanDesc;
    private Method writeMethod;
    private Method readMethod;
    private PropertyDesc propertyDesc;

    public IndexedPropertyDescImpl(String propertyName, Class propertyType, BeanDesc beanDesc) {
        this.propertyName = propertyName;
        this.propertyType = propertyType;
        this.beanDesc = beanDesc;
        this.setupMethods();
        this.propertyDesc = new PropertyDescImpl(propertyName, propertyType, this.readMethod, this.writeMethod, beanDesc);
    }

    private void setupMethods() {
        Class<?>[] parameterTypes;
        int i;
        String methodName = this.propertyName.substring(0, 1).toUpperCase() + this.propertyName.substring(1);
        Method[] getMethods = new Method[]{};
        try {
            getMethods = this.beanDesc.getMethods("get" + methodName);
        }
        catch (MethodNotFoundRuntimeException e) {
            // empty catch block
        }
        Method[] setMethods = new Method[]{};
        try {
            setMethods = this.beanDesc.getMethods("set" + methodName);
        }
        catch (MethodNotFoundRuntimeException e) {
            // empty catch block
        }
        for (i = 0; i < getMethods.length; ++i) {
            parameterTypes = getMethods[i].getParameterTypes();
            if (parameterTypes.length != 1 || !parameterTypes[0].equals(Integer.TYPE)) continue;
            this.readMethod = getMethods[i];
        }
        for (i = 0; i < setMethods.length; ++i) {
            parameterTypes = setMethods[i].getParameterTypes();
            if (parameterTypes.length != 2 || !parameterTypes[0].equals(Integer.TYPE) || !parameterTypes[1].equals(this.propertyType)) continue;
            this.writeMethod = setMethods[i];
        }
    }

    public void setValue(Object target, int index, Object value) {
        try {
            MethodUtil.invoke((Method)this.writeMethod, (Object)target, (Object[])new Object[]{new Integer(index), this.convertIfNeed(value)});
        }
        catch (Throwable t) {
            throw new IllegalPropertyRuntimeException(this.beanDesc.getBeanClass(), this.propertyName, t);
        }
    }

    public Object getValue(Object target, int index) {
        return MethodUtil.invoke((Method)this.readMethod, (Object)target, (Object[])new Object[]{new Integer(index)});
    }

    public boolean hasReadMethod() {
        return this.readMethod != null;
    }

    public boolean hasWriteMethod() {
        return this.writeMethod != null;
    }

    private Object convertIfNeed(Object arg) {
        return this.propertyDesc.convertIfNeed(arg);
    }
}

