/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import javax.sql.DataSource;
import org.seasar.dao.CommandContext;
import org.seasar.dao.Node;
import org.seasar.dao.context.CommandContextImpl;
import org.seasar.dao.impl.AbstractSqlCommand;
import org.seasar.dao.parser.SqlParserImpl;
import org.seasar.extension.jdbc.CallableStatementFactory;

public abstract class AbstractDynamicCommand
extends AbstractSqlCommand {
    private Node rootNode_;
    private String[] argNames_ = new String[0];
    private Class[] argTypes_ = new Class[0];

    public AbstractDynamicCommand(DataSource dataSource, CallableStatementFactory callableStatementFactory) {
        super(dataSource, callableStatementFactory);
    }

    public void setSql(String sql) {
        super.setSql(sql);
        this.rootNode_ = new SqlParserImpl(sql).parse();
    }

    public String[] getArgNames() {
        return this.argNames_;
    }

    public void setArgNames(String[] argNames) {
        this.argNames_ = argNames;
    }

    public Class[] getArgTypes() {
        return this.argTypes_;
    }

    public void setArgTypes(Class[] argTypes) {
        this.argTypes_ = argTypes;
    }

    protected CommandContext apply(Object[] args) {
        CommandContext ctx = this.createCommandContext(args);
        this.rootNode_.accept(ctx);
        return ctx;
    }

    protected CommandContext createCommandContext(Object[] args) {
        CommandContextImpl ctx = new CommandContextImpl();
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                Class<?> argType = null;
                if (args[i] != null) {
                    if (i < this.argTypes_.length) {
                        argType = this.argTypes_[i];
                    } else if (args[i] != null) {
                        argType = args[i].getClass();
                    }
                }
                if (i < this.argNames_.length) {
                    ctx.addArg(this.argNames_[i], args[i], argType);
                } else {
                    ctx.addArg("$" + (i + 1), args[i], argType);
                }
                ++i;
            }
        }
        return ctx;
    }
}

