package org.seasar.dao.impl;

import javax.sql.DataSource;

import org.seasar.dao.SqlCommand;
import org.seasar.extension.jdbc.CallableStatementFactory;

/**
 * @author higa
 *  
 */
public abstract class AbstractSqlCommand implements SqlCommand {

	private DataSource dataSource_;
	
	private CallableStatementFactory callableStatementFactory_;

	private String sql_;

	public AbstractSqlCommand(DataSource dataSource,
			CallableStatementFactory callableStatementFactory) {
		
		dataSource_ = dataSource;
		callableStatementFactory_ = callableStatementFactory;
	}

	public DataSource getDataSource() {
		return dataSource_;
	}
	
	public CallableStatementFactory getCallableStatementFactory() {
		return callableStatementFactory_;
	}

	public String getSql() {
		return sql_;
	}

	public void setSql(String sql) {
		sql_ = sql;
	}
}