/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.dialect.PostgreSQLDialect;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.AbstractCriterion;
import net.sf.hibernate.expression.MatchMode;

public class IlikeExpression
extends AbstractCriterion {
    private final String propertyName;
    private final Object value;

    IlikeExpression(String propertyName, Object value) {
        this.propertyName = propertyName;
        this.value = value;
    }

    IlikeExpression(String propertyName, String value, MatchMode matchMode) {
        this(propertyName, matchMode.toMatchString(value));
    }

    public String toSqlString(SessionFactoryImplementor sessionFactory, Class persistentClass, String alias, Map aliasClasses) throws HibernateException {
        Dialect dialect = sessionFactory.getDialect();
        String[] columns = IlikeExpression.getColumns(sessionFactory, persistentClass, this.propertyName, alias, aliasClasses);
        if (columns.length != 1) {
            throw new HibernateException("ilike may only be used with single-column properties");
        }
        if (dialect instanceof PostgreSQLDialect) {
            return columns[0] + " ilike ?";
        }
        return dialect.getLowercaseFunction() + '(' + columns[0] + ") like ?";
    }

    public TypedValue[] getTypedValues(SessionFactoryImplementor sessionFactory, Class persistentClass, Map aliasClasses) throws HibernateException {
        return new TypedValue[]{IlikeExpression.getTypedValue(sessionFactory, persistentClass, this.propertyName, this.value.toString().toLowerCase(), aliasClasses)};
    }

    public String toString() {
        return this.propertyName + " ilike " + this.value;
    }
}

