/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import java.util.ArrayList;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.AbstractCriterion;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.StringHelper;

public class InExpression
extends AbstractCriterion {
    private final String propertyName;
    private final Object[] values;

    InExpression(String propertyName, Object[] values) {
        this.propertyName = propertyName;
        this.values = values;
    }

    public String toSqlString(SessionFactoryImplementor sessionFactory, Class persistentClass, String alias, Map aliasClasses) throws HibernateException {
        String params;
        if (this.values.length > 0) {
            params = StringHelper.repeat("?, ", this.values.length - 1);
            params = params + "?";
        } else {
            params = "";
        }
        String condition = " in (" + params + ')';
        return StringHelper.join(" and ", StringHelper.suffix(InExpression.getColumns(sessionFactory, persistentClass, this.propertyName, alias, aliasClasses), condition));
    }

    public TypedValue[] getTypedValues(SessionFactoryImplementor sessionFactory, Class persistentClass, Map aliasClasses) throws HibernateException {
        ArrayList<TypedValue> list = new ArrayList<TypedValue>();
        Type type = InExpression.getType(sessionFactory, persistentClass, this.propertyName, aliasClasses);
        if (type.isComponentType()) {
            AbstractComponentType actype = (AbstractComponentType)type;
            Type[] types = actype.getSubtypes();
            for (int i = 0; i < types.length; ++i) {
                for (int j = 0; j < this.values.length; ++j) {
                    Object subval = this.values[j] == null ? null : actype.getPropertyValues(this.values[j])[i];
                    list.add(new TypedValue(types[i], subval));
                }
            }
        } else {
            for (int j = 0; j < this.values.length; ++j) {
                list.add(new TypedValue(type, this.values[j]));
            }
        }
        return list.toArray(new TypedValue[list.size()]);
    }

    public String toString() {
        return this.propertyName + " in (" + StringHelper.toString(this.values) + ')';
    }
}

