package org.seasar.hibernate.dao.impl;

import java.lang.reflect.Method;

import net.sf.hibernate.Criteria;
import net.sf.hibernate.HibernateException;

import org.seasar.hibernate.S2Session;
import org.seasar.hibernate.S2SessionFactory;
import org.seasar.hibernate.dao.criteria.CriteriaCommand;

/**
 * @author kenichi_okazaki 
 */
public class AutoArgsQueryCommand extends AbstractAutoQueryCommand {

	public AutoArgsQueryCommand(S2SessionFactory s2sessionFactory,Class beanClass, Method method) {
		super(s2sessionFactory, beanClass,method);
	}


	protected Criteria getArgsCriteria(S2Session s2session, Object[] args) throws HibernateException {
		String[] argNames = getArgNames();
		
		Criteria criteria = s2session.createCriteria( getBeanClass() );
		for (int i = 0; i < argNames.length; i++) {
			if (args[i] != null) {
				CriteriaCommand criteriaCommand = (CriteriaCommand)criteriaCommandList_.get(i);
				criteria = criteriaCommand.getCriteria( criteria, args[i] ) ;
			}
		}
		return criteria;
	}

}