/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.openamf;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.openamf.ServiceRequest;
import org.openamf.invoker.ServiceInvocationException;
import org.openamf.invoker.ServiceInvoker;
import org.seasar.extension.openamf.ASTranslator;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.servlet.S2ContainerServlet;

public class S2ServiceInvoker
extends ServiceInvoker {
    public S2ServiceInvoker(ServiceRequest request, HttpServletRequest httpServletRequest, ServletContext servletContext) {
        super(request, httpServletRequest, servletContext);
    }

    public Object invokeService() throws ServiceInvocationException {
        String serviceName = this.request.getServiceName();
        String methodName = this.request.getServiceMethodName();
        S2Container container = S2ContainerServlet.getContainer();
        Object component = null;
        Object result = null;
        try {
            component = container.hasComponentDef((Object)serviceName) ? container.getComponent((Object)serviceName) : container.getComponent(Class.forName(serviceName));
            Object[] parameters = this.request.getParameters().toArray();
            ASTranslator ast = new ASTranslator();
            int i = 0;
            while (i < parameters.length) {
                Object conv;
                parameters[i] = conv = ast.fromActionScript(parameters[i]);
                ++i;
            }
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(component.getClass());
            result = beanDesc.invoke(component, methodName, parameters);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new ServiceInvocationException(this.request, cause);
        }
        return result;
    }

    public boolean supports(ServiceRequest request) {
        String serviceName;
        S2Container container = S2ContainerServlet.getContainer();
        if (container.hasComponentDef((Object)(serviceName = request.getServiceName()))) {
            return true;
        }
        try {
            return container.hasComponentDef(Class.forName(serviceName));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

