/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.ext;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.html.ext.HtmlMessage;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HtmlMessageRendererBase;

public class HtmlMessageRenderer
extends HtmlMessageRendererBase {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$renderkit$html$ext$HtmlMessageRenderer == null ? (class$org$apache$myfaces$renderkit$html$ext$HtmlMessageRenderer = HtmlMessageRenderer.class$("org.apache.myfaces.renderkit.html.ext.HtmlMessageRenderer")) : class$org$apache$myfaces$renderkit$html$ext$HtmlMessageRenderer));
    private static final String OUTPUT_LABEL_MAP = (class$org$apache$myfaces$renderkit$html$ext$HtmlMessageRenderer == null ? (class$org$apache$myfaces$renderkit$html$ext$HtmlMessageRenderer = HtmlMessageRenderer.class$("org.apache.myfaces.renderkit.html.ext.HtmlMessageRenderer")) : class$org$apache$myfaces$renderkit$html$ext$HtmlMessageRenderer).getName() + ".OUTPUT_LABEL_MAP";
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$ext$HtmlMessageRenderer;

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeEnd(facesContext, component);
        this.renderMessage(facesContext, component);
    }

    protected String getSummary(FacesContext facesContext, UIComponent message, FacesMessage facesMessage, String msgClientId) {
        String msgSummary = facesMessage.getSummary();
        if (msgSummary == null) {
            return null;
        }
        String summaryFormat = message instanceof HtmlMessage ? ((HtmlMessage)message).getSummaryFormat() : (String)message.getAttributes().get("summaryFormat");
        if (summaryFormat == null) {
            return msgSummary;
        }
        String inputLabel = null;
        if (msgClientId != null) {
            inputLabel = HtmlMessageRenderer.findInputLabel(facesContext, msgClientId);
        }
        if (inputLabel == null) {
            inputLabel = "";
        }
        MessageFormat format = new MessageFormat(summaryFormat, facesContext.getViewRoot().getLocale());
        return format.format(new Object[]{msgSummary, inputLabel});
    }

    protected String getDetail(FacesContext facesContext, UIComponent message, FacesMessage facesMessage, String msgClientId) {
        String msgDetail = facesMessage.getDetail();
        if (msgDetail == null) {
            return null;
        }
        String detailFormat = message instanceof HtmlMessage ? ((HtmlMessage)message).getDetailFormat() : (String)message.getAttributes().get("detailFormat");
        if (detailFormat == null) {
            return msgDetail;
        }
        String inputLabel = null;
        if (msgClientId != null) {
            inputLabel = HtmlMessageRenderer.findInputLabel(facesContext, msgClientId);
        }
        if (inputLabel == null) {
            inputLabel = "";
        }
        MessageFormat format = new MessageFormat(detailFormat, facesContext.getViewRoot().getLocale());
        return format.format(new Object[]{msgDetail, inputLabel});
    }

    public static String findInputLabel(FacesContext facesContext, String inputClientId) {
        Map outputLabelMap = HtmlMessageRenderer.getOutputLabelMap(facesContext);
        return (String)outputLabelMap.get(inputClientId);
    }

    private static Map getOutputLabelMap(FacesContext facesContext) {
        HashMap map = (HashMap)facesContext.getExternalContext().getRequestMap().get(OUTPUT_LABEL_MAP);
        if (map == null) {
            map = new HashMap();
            HtmlMessageRenderer.createOutputLabelMap(facesContext, facesContext.getViewRoot(), map);
            facesContext.getExternalContext().getRequestMap().put(OUTPUT_LABEL_MAP, map);
        }
        return map;
    }

    private static void createOutputLabelMap(FacesContext facesContext, UIComponent root, Map map) {
        Iterator it = root.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (child instanceof HtmlOutputLabel) {
                String forAttr = ((HtmlOutputLabel)child).getFor();
                UIComponent input = child.findComponent(forAttr);
                if (input == null) {
                    log.warn((Object)("Unable to find component '" + forAttr + "' (calling findComponent on component '" + child.getClientId(facesContext) + "')"));
                    continue;
                }
                map.put(input.getClientId(facesContext), HtmlMessageRenderer.getLabelText(facesContext, (HtmlOutputLabel)child));
                continue;
            }
            HtmlMessageRenderer.createOutputLabelMap(facesContext, child, map);
        }
    }

    private static String getLabelText(FacesContext facesContext, HtmlOutputLabel label) {
        String text = RendererUtils.getStringValue(facesContext, label);
        if (text == null) {
            // empty if block
        }
        return text;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

