/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.application;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.ClassUtil;
import org.seasar.jsf.ViewTemplate;
import org.seasar.jsf.ViewTemplateFactory;
import org.seasar.jsf.application.TreeStructure;
import org.seasar.jsf.processor.ViewProcessor;

public class S2StateManager
extends StateManager
implements Serializable {
    static final long serialVersionUID = 0L;
    private static final String SERIALIZED_VIEW_ATTR = String.valueOf(S2StateManager.class.getName()) + ".SERIALIZED_VIEW";
    private static final String LAST_MODIFIED_ATTR = String.valueOf(S2StateManager.class.getName()) + ".LAST_MODIFIED";
    private transient RenderKitFactory renderKitFactory;
    private transient ViewTemplateFactory viewTemplateFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public StateManager.SerializedView saveSerializedView(FacesContext context) throws IllegalStateException {
        UIViewRoot viewRoot = context.getViewRoot();
        ExternalContext externalContext = context.getExternalContext();
        this.saveLastModifiedToSession(externalContext, viewRoot.getViewId());
        Object struct = this.getTreeStructureToSave(context);
        Object state = this.getComponentStateToSave(context);
        StateManager.SerializedView serializedView = new StateManager.SerializedView((StateManager)this, struct, state);
        if (this.isSavingStateInClient(context)) {
            return serializedView;
        }
        this.saveSerializedViewToSession(externalContext, viewRoot.getViewId(), serializedView);
        return null;
    }

    protected void saveLastModifiedToSession(ExternalContext externalContext, String viewId) {
        Long lm = new Long(this.getLastModifiedFromFile(viewId));
        externalContext.getSessionMap().put(String.valueOf(LAST_MODIFIED_ATTR) + "-" + viewId, lm);
    }

    protected long getLastModifiedFromSession(ExternalContext externalContext, String viewId) {
        Long lm = (Long)externalContext.getSessionMap().get(String.valueOf(LAST_MODIFIED_ATTR) + "-" + viewId);
        if (lm != null) {
            return lm;
        }
        return 0L;
    }

    protected void removeLastModifiedFromSession(ExternalContext externalContext, String viewId) {
        externalContext.getSessionMap().remove(String.valueOf(LAST_MODIFIED_ATTR) + "-" + viewId);
    }

    protected boolean isViewModified(ExternalContext externalContext, String viewId) {
        long lastModifiedFromSession = this.getLastModifiedFromSession(externalContext, viewId);
        long lastModifiedFromFile = this.getLastModifiedFromFile(viewId);
        return lastModifiedFromFile > lastModifiedFromSession;
    }

    protected long getLastModifiedFromFile(String viewId) {
        ViewTemplateFactory vtf = this.getViewTemplateFactory();
        ViewTemplate vt = vtf.getViewTemplate(viewId);
        long lastModified = vt.getLastModified();
        if (lastModified == 0L) {
            return lastModified;
        }
        ViewProcessor vp = (ViewProcessor)vt.getRootTagProcessor();
        String[] includes = vp.getIncludes();
        int i = 0;
        while (i < includes.length) {
            vt = vtf.getViewTemplate(includes[i]);
            long lm = vt.getLastModified();
            if (lm > lastModified) {
                lastModified = lm;
            }
            ++i;
        }
        return lastModified;
    }

    protected StateManager.SerializedView getSerializedViewFromSession(ExternalContext externalContext, String viewId) {
        return (StateManager.SerializedView)externalContext.getSessionMap().get(String.valueOf(SERIALIZED_VIEW_ATTR) + "-" + viewId);
    }

    protected void saveSerializedViewToSession(ExternalContext externalContext, String viewId, StateManager.SerializedView serializedView) {
        externalContext.getSessionMap().put(String.valueOf(SERIALIZED_VIEW_ATTR) + "-" + viewId, serializedView);
    }

    protected void removeSerializedViewFromSession(ExternalContext externalContext, String viewId) {
        externalContext.getSessionMap().remove(String.valueOf(SERIALIZED_VIEW_ATTR) + "-" + viewId);
    }

    protected Object getTreeStructureToSave(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return null;
        }
        return this.buildTreeStructure((UIComponent)viewRoot);
    }

    protected Object getComponentStateToSave(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return null;
        }
        return viewRoot.processSaveState(context);
    }

    protected TreeStructure buildTreeStructure(UIComponent component) {
        TreeStructure struct = new TreeStructure(component.getClass().getName(), component.getId());
        struct.setChildren(this.buildChildrenTreeStructure(component));
        struct.setFacets(this.buildFacetsTreeStructure(component));
        return struct;
    }

    protected TreeStructure[] buildChildrenTreeStructure(UIComponent component) {
        if (component.getChildCount() > 0) {
            List children = component.getChildren();
            ArrayList<TreeStructure> structs = new ArrayList<TreeStructure>();
            int i = 0;
            while (i < children.size()) {
                UIComponent child = (UIComponent)children.get(i);
                if (!child.isTransient()) {
                    TreeStructure childStruct = this.buildTreeStructure(child);
                    structs.add(childStruct);
                }
                ++i;
            }
            return structs.toArray(new TreeStructure[structs.size()]);
        }
        return null;
    }

    protected Object[] buildFacetsTreeStructure(UIComponent component) {
        Map facets = component.getFacets();
        if (!facets.isEmpty()) {
            ArrayList<Object[]> structs = new ArrayList<Object[]>();
            for (Map.Entry entry : facets.entrySet()) {
                UIComponent child = (UIComponent)entry.getValue();
                if (child.isTransient()) continue;
                String facetName = (String)entry.getKey();
                TreeStructure struct = this.buildTreeStructure(child);
                structs.add(new Object[]{facetName, struct});
            }
            return structs.toArray();
        }
        return null;
    }

    public void writeState(FacesContext context, StateManager.SerializedView serializedView) throws IOException {
        UIViewRoot viewRoot = context.getViewRoot();
        RenderKit renderKit = this.getRenderKit(context, viewRoot.getRenderKitId());
        renderKit.getResponseStateManager().writeState(context, serializedView);
    }

    protected RenderKit getRenderKit(FacesContext context, String renderKitId) {
        return this.getRenderKitFactory().getRenderKit(context, renderKitId);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        ExternalContext extContext = context.getExternalContext();
        if (this.isViewModified(extContext, viewId)) {
            this.removeSerializedViewFromSession(extContext, viewId);
            this.removeLastModifiedFromSession(extContext, viewId);
            return null;
        }
        UIViewRoot viewRoot = this.restoreTreeStructure(context, viewId, renderKitId);
        if (viewRoot != null) {
            viewRoot.setViewId(viewId);
            this.restoreComponentState(context, viewRoot, renderKitId);
        }
        return viewRoot;
    }

    protected UIViewRoot restoreTreeStructure(FacesContext context, String viewId, String renderKitId) {
        if (this.isSavingStateInClient(context)) {
            return this.restoreTreeStructureFromClient(context, viewId, renderKitId);
        }
        return this.restoreTreeStructureFromServer(context, viewId);
    }

    protected UIViewRoot restoreTreeStructureFromClient(FacesContext context, String viewId, String renderKitId) {
        RenderKit renderKit = this.getRenderKit(context, renderKitId);
        ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
        TreeStructure struct = (TreeStructure)responseStateManager.getTreeStructureToRestore(context, viewId);
        if (struct == null) {
            return null;
        }
        return (UIViewRoot)this.restoreTreeStructure(struct);
    }

    protected UIViewRoot restoreTreeStructureFromServer(FacesContext context, String viewId) {
        StateManager.SerializedView serializedView = this.getSerializedViewFromSession(context.getExternalContext(), viewId);
        if (serializedView == null) {
            return null;
        }
        TreeStructure struct = (TreeStructure)serializedView.getStructure();
        return (UIViewRoot)this.restoreTreeStructure(struct);
    }

    protected UIComponent restoreTreeStructure(TreeStructure struct) {
        String className = struct.getComponentClassName();
        String id = struct.getComponentId();
        UIComponent component = (UIComponent)ClassUtil.newInstance((String)className);
        component.setId(id);
        this.restoreChildrenTreeStructure(component, struct.getChildren());
        this.restoreFacetsTreeStructure(component, struct.getFacets());
        return component;
    }

    protected void restoreChildrenTreeStructure(UIComponent component, TreeStructure[] structs) {
        if (structs != null) {
            int i = 0;
            while (i < structs.length) {
                UIComponent child = this.restoreTreeStructure(structs[i]);
                component.getChildren().add(child);
                ++i;
            }
        }
    }

    protected void restoreFacetsTreeStructure(UIComponent component, Object[] facets) {
        if (facets != null) {
            int i = 0;
            int len = facets.length;
            while (i < len) {
                Object[] array = (Object[])facets[i];
                String facetName = (String)array[0];
                TreeStructure struct = (TreeStructure)array[1];
                UIComponent child = this.restoreTreeStructure(struct);
                component.getFacets().put(facetName, child);
                ++i;
            }
        }
    }

    protected void restoreComponentState(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
        if (viewRoot.getRenderKitId() == null) {
            viewRoot.setRenderKitId(renderKitId);
        }
        if (this.isSavingStateInClient(context)) {
            this.restoreComponentStateFromClient(context, viewRoot, renderKitId);
        } else {
            this.restoreComponentStateFromServer(context, viewRoot);
        }
    }

    protected void restoreComponentStateFromClient(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
        RenderKit renderKit = this.getRenderKit(context, renderKitId);
        ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
        Object state = responseStateManager.getComponentStateToRestore(context);
        viewRoot.processRestoreState(context, state);
    }

    protected void restoreComponentStateFromServer(FacesContext context, UIViewRoot viewRoot) {
        StateManager.SerializedView serializedView = this.getSerializedViewFromSession(context.getExternalContext(), viewRoot.getViewId());
        if (serializedView == null) {
            return;
        }
        Object state = serializedView.getState();
        if (state == null) {
            return;
        }
        viewRoot.processRestoreState(context, state);
    }

    protected RenderKitFactory getRenderKitFactory() {
        if (this.renderKitFactory == null) {
            this.renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        }
        return this.renderKitFactory;
    }

    protected ViewTemplateFactory getViewTemplateFactory() {
        if (this.viewTemplateFactory == null) {
            S2Container container = SingletonS2ContainerFactory.getContainer();
            this.viewTemplateFactory = (ViewTemplateFactory)container.getComponent(ViewTemplateFactory.class);
        }
        return this.viewTemplateFactory;
    }
}

