/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.seasar.jsf.exception.NoSelectItemRuntimeException;

public final class SelectItemUtil {
    private SelectItemUtil() {
    }

    public static List getSelectItemList(UIComponent component) {
        ArrayList list = new ArrayList(component.getChildCount());
        for (UIComponent child : component.getChildren()) {
            if (child instanceof UISelectItem) {
                SelectItemUtil.addSelectItem(list, (UISelectItem)child);
                continue;
            }
            if (!(child instanceof UISelectItems)) continue;
            SelectItemUtil.addSelectItems(list, (UISelectItems)child);
        }
        return list;
    }

    public static void addSelectItem(List list, UISelectItem component) {
        SelectItem selectItem = SelectItemUtil.getSelectItem(component);
        list.add(selectItem);
    }

    public static SelectItem getSelectItem(UISelectItem component) {
        Object value = component.getValue();
        if (value != null) {
            return SelectItemUtil.convertValueAsSelectItem(value, (UIComponent)component);
        }
        Object itemValue = component.getItemValue();
        String label = component.getItemLabel();
        String description = component.getItemDescription();
        boolean disabled = component.isItemDisabled();
        return SelectItemUtil.createSelectItem(itemValue, label, description, disabled);
    }

    public static SelectItem convertValueAsSelectItem(Object value, UIComponent component) {
        if (value instanceof SelectItem) {
            return (SelectItem)value;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        String clientId = component.getClientId(context);
        throw new NoSelectItemRuntimeException(clientId);
    }

    public static SelectItem createSelectItem(Object value, String label, String description, boolean disabled) {
        if (label == null && value != null) {
            label = value.toString();
        }
        SelectItem selectItem = new SelectItem();
        if (value != null) {
            selectItem.setValue(value);
        }
        if (label != null) {
            selectItem.setLabel(label);
        }
        selectItem.setDescription(description);
        selectItem.setDisabled(disabled);
        return selectItem;
    }

    public static void addSelectItems(List list, UISelectItems component) {
        Object value = component.getValue();
        if (value instanceof SelectItem) {
            list.add(value);
        } else if (value instanceof SelectItem[]) {
            SelectItem[] items = (SelectItem[])value;
            int i = 0;
            while (i < items.length) {
                list.add(items[i]);
                ++i;
            }
        } else if (value instanceof Collection) {
            for (Object item : (Collection)value) {
                list.add(SelectItemUtil.convertValueAsSelectItem(item, (UIComponent)component));
            }
        } else {
            FacesContext context = FacesContext.getCurrentInstance();
            String clientId = component.getClientId(context);
            throw new NoSelectItemRuntimeException(clientId);
        }
    }
}

