/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import java.io.PrintWriter;
import javassist.NotFoundException;
import javassist.compiler.CompileError;

public class CannotCompileException
extends Exception {
    private String message;
    private Throwable cause;

    public String getReason() {
        if (this.message != null) {
            return this.message;
        }
        return this.toString();
    }

    public CannotCompileException(String msg) {
        super(msg);
        this.message = msg;
        this.cause = null;
    }

    public CannotCompileException(Throwable e) {
        super("by " + e.toString());
        this.message = null;
        this.cause = e;
    }

    public CannotCompileException(String msg, Throwable e) {
        this(msg);
        this.cause = e;
    }

    public CannotCompileException(NotFoundException e) {
        this("cannot find " + e.getMessage(), e);
    }

    public CannotCompileException(CompileError e) {
        this("[source error] " + e.getMessage(), e);
    }

    public CannotCompileException(ClassNotFoundException e, String name) {
        this("cannot find " + name, e);
    }

    public CannotCompileException(ClassFormatError e, String name) {
        this("invalid class format: " + name, e);
    }

    public void printStackTrace(PrintWriter w) {
        super.printStackTrace(w);
        if (this.cause != null) {
            w.println("Caused by:");
            this.cause.printStackTrace(w);
        }
    }
}

