/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet;

import java.io.IOException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.UnavailableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.config.FacesConfigurator;
import org.apache.myfaces.context.ReleaseableExternalContext;
import org.apache.myfaces.context.portlet.PortletExternalContextImpl;
import org.apache.myfaces.context.servlet.ServletFacesContextImpl;
import org.apache.myfaces.portlet.DefaultViewSelector;
import org.apache.myfaces.portlet.PortletUtil;
import org.apache.myfaces.webapp.webxml.WebXml;

public class MyFacesGenericPortlet
extends GenericPortlet {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$portlet$MyFacesGenericPortlet == null ? (class$org$apache$myfaces$portlet$MyFacesGenericPortlet = MyFacesGenericPortlet.class$("org.apache.myfaces.portlet.MyFacesGenericPortlet")) : class$org$apache$myfaces$portlet$MyFacesGenericPortlet));
    public static final String VIEW_ID = (class$org$apache$myfaces$portlet$MyFacesGenericPortlet == null ? (class$org$apache$myfaces$portlet$MyFacesGenericPortlet = MyFacesGenericPortlet.class$("org.apache.myfaces.portlet.MyFacesGenericPortlet")) : class$org$apache$myfaces$portlet$MyFacesGenericPortlet).getName() + ".VIEW_ID";
    private static final String CURRENT_FACES_CONTEXT = (class$org$apache$myfaces$portlet$MyFacesGenericPortlet == null ? (class$org$apache$myfaces$portlet$MyFacesGenericPortlet = MyFacesGenericPortlet.class$("org.apache.myfaces.portlet.MyFacesGenericPortlet")) : class$org$apache$myfaces$portlet$MyFacesGenericPortlet).getName() + ".CURRENT_FACES_CONTEXT";
    private static final String DEFAULT_VIEW = "default-view";
    private static final String DEFAULT_VIEW_SELECTOR = "default-view-selector";
    private static final String FACES_INIT_DONE = (class$org$apache$myfaces$portlet$MyFacesGenericPortlet == null ? (class$org$apache$myfaces$portlet$MyFacesGenericPortlet = MyFacesGenericPortlet.class$("org.apache.myfaces.portlet.MyFacesGenericPortlet")) : class$org$apache$myfaces$portlet$MyFacesGenericPortlet).getName() + ".FACES_INIT_DONE";
    private PortletContext portletContext;
    private FacesContextFactory facesContextFactory;
    private Lifecycle lifecycle;
    private String defaultView;
    private DefaultViewSelector defaultViewSelector;
    static /* synthetic */ Class class$org$apache$myfaces$portlet$MyFacesGenericPortlet;

    public void destroy() {
        super.destroy();
        FactoryFinder.releaseFactories();
    }

    public void init() throws PortletException, UnavailableException {
        this.portletContext = this.getPortletContext();
        this.setDefaultView();
        this.setDefaultViewSelector();
        this.initMyFaces();
        this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory("javax.faces.context.FacesContextFactory");
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
        this.lifecycle = lifecycleFactory.getLifecycle(this.getLifecycleId());
    }

    private void setDefaultView() throws UnavailableException {
        this.defaultView = this.getPortletConfig().getInitParameter(DEFAULT_VIEW);
        if (this.defaultView == null) {
            String msg = "Fatal: must specify a JSF view id as the default view in portlet.xml";
            throw new UnavailableException(msg);
        }
    }

    private void setDefaultViewSelector() throws UnavailableException {
        String selectorClass = this.getPortletConfig().getInitParameter(DEFAULT_VIEW_SELECTOR);
        if (selectorClass == null) {
            return;
        }
        try {
            this.defaultViewSelector = (DefaultViewSelector)Class.forName(selectorClass).newInstance();
            this.defaultViewSelector.setPortletContext(this.getPortletContext());
        }
        catch (Exception e) {
            log.error((Object)"Failed to load default-view-selector", (Throwable)e);
            throw new UnavailableException(e.getMessage());
        }
    }

    private String getLifecycleId() {
        String lifecycleId = this.getPortletConfig().getInitParameter("javax.faces.LIFECYCLE_ID");
        return lifecycleId != null ? lifecycleId : "DEFAULT";
    }

    private void initMyFaces() {
        try {
            Boolean b = (Boolean)this.portletContext.getAttribute(FACES_INIT_DONE);
            if (b == null || !b.booleanValue()) {
                log.trace((Object)"Initializing MyFaces");
                PortletExternalContextImpl externalContext = new PortletExternalContextImpl(this.portletContext, null, null);
                new FacesConfigurator(externalContext).configure();
                WebXml.init(externalContext);
                this.portletContext.setAttribute(FACES_INIT_DONE, (Object)Boolean.TRUE);
            } else {
                log.info((Object)"MyFaces already initialized");
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error initializing MyFacesGenericPortlet", (Throwable)ex);
        }
        log.info((Object)("PortletContext '" + this.portletContext.getRealPath("/") + "' initialized."));
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"called processAction");
        }
        if (this.sessionTimedOut((PortletRequest)request)) {
            return;
        }
        this.setPortletRequestFlag((PortletRequest)request);
        FacesContext facesContext = this.facesContext((PortletRequest)request, (PortletResponse)response);
        try {
            this.lifecycle.execute(facesContext);
            if (!facesContext.getResponseComplete()) {
                response.setRenderParameter(VIEW_ID, facesContext.getViewRoot().getViewId());
            }
            request.getPortletSession().setAttribute(CURRENT_FACES_CONTEXT, (Object)facesContext);
        }
        catch (Throwable e) {
            facesContext.release();
            this.handleExceptionFromLifecycle(e);
        }
    }

    private void handleExceptionFromLifecycle(Throwable e) throws PortletException, IOException {
        this.logException(e, null);
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof PortletException) {
            throw (PortletException)e;
        }
        if (e.getMessage() != null) {
            throw new PortletException(e.getMessage(), e);
        }
        throw new PortletException(e);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.facesRender(request, response);
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.facesRender(request, response);
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.facesRender(request, response);
    }

    protected void nonFacesRequest(RenderRequest request, RenderResponse response) throws PortletException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Non-faces request: contextPath = " + request.getContextPath()));
        }
        ApplicationFactory appFactory = (ApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory");
        Application application = appFactory.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        FacesContext facesContext = this.facesContext((PortletRequest)request, (PortletResponse)response);
        UIViewRoot view = viewHandler.createView(facesContext, this.selectDefaultView(request, response));
        facesContext.setViewRoot(view);
        this.lifecycle.render(facesContext);
    }

    private String selectDefaultView(RenderRequest request, RenderResponse response) throws PortletException {
        String selectedView;
        String view = this.defaultView;
        if (this.defaultViewSelector != null && (selectedView = this.defaultViewSelector.selectViewId(request, response)) != null) {
            view = selectedView;
        }
        return view;
    }

    private FacesContext facesContext(PortletRequest request, PortletResponse response) {
        return this.facesContextFactory.getFacesContext(this.portletContext, request, response, this.lifecycle);
    }

    private ReleaseableExternalContext makeExternalContext(PortletRequest request, PortletResponse response) {
        return new PortletExternalContextImpl(this.portletContext, request, response);
    }

    private boolean sessionTimedOut(PortletRequest request) {
        return request.getPortletSession(false) == null;
    }

    private void setPortletRequestFlag(PortletRequest request) {
        request.getPortletSession().setAttribute(PortletUtil.PORTLET_REQUEST_FLAG, (Object)"true");
    }

    protected void facesRender(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"called facesRender");
        }
        response.setContentType("text/html");
        String viewId = request.getParameter(VIEW_ID);
        if (viewId == null || this.sessionTimedOut((PortletRequest)request)) {
            this.setPortletRequestFlag((PortletRequest)request);
            this.nonFacesRequest(request, response);
            return;
        }
        this.setPortletRequestFlag((PortletRequest)request);
        try {
            ServletFacesContextImpl facesContext = (ServletFacesContextImpl)request.getPortletSession().getAttribute(CURRENT_FACES_CONTEXT);
            if (facesContext.getResponseComplete()) {
                return;
            }
            facesContext.setExternalContext(this.makeExternalContext((PortletRequest)request, (PortletResponse)response));
            this.lifecycle.render(facesContext);
        }
        catch (Throwable e) {
            this.handleExceptionFromLifecycle(e);
        }
    }

    private void logException(Throwable e, String msgPrefix) {
        String msg = msgPrefix == null ? (e.getMessage() == null ? "Exception in FacesServlet" : e.getMessage()) : (e.getMessage() == null ? msgPrefix : msgPrefix + ": " + e.getMessage());
        this.portletContext.log(msg, e);
        Throwable cause = e.getCause();
        if (cause != null && cause != e) {
            this.logException(cause, "Root cause");
        }
        if (e instanceof PortletException && (cause = ((PortletException)e).getCause()) != null && cause != e) {
            this.logException(cause, "Root cause of PortletException");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

