/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.Tag;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.jsf.JsfConfig;
import org.seasar.jsf.JsfContext;
import org.seasar.jsf.TagConfig;
import org.seasar.jsf.TagProcessor;
import org.xml.sax.Attributes;

public class TagProcessorImpl
implements TagProcessor {
    private static final String INSERT_PROCESSOR_MAP_ATTR;
    private Map properties = new HashMap();
    private Class tagClass;
    private List children = new ArrayList();
    private TagProcessor parent;
    private Set customPropertyNames = new HashSet();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.jsf.processor.TagProcessorImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INSERT_PROCESSOR_MAP_ATTR = String.valueOf(clazz.getName()) + ".INSERT_PROCESSOR_MAP";
    }

    public TagProcessorImpl() {
    }

    public TagProcessorImpl(String inject) {
        this.setProperty("inject", inject);
    }

    public void setProperties(Tag tag, JsfContext jsfContext) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(tag.getClass());
        Iterator i = this.getPropertyKeys();
        while (i.hasNext()) {
            String propertyName = (String)i.next();
            String value = this.getProperty(propertyName);
            String s = value;
            if (StringUtil.isEmpty((String)s) || this.isCustomProperty(propertyName) || !beanDesc.hasPropertyDesc(propertyName) || value == null) continue;
            PropertyDesc pd = beanDesc.getPropertyDesc(propertyName);
            pd.setValue((Object)tag, (Object)value);
        }
    }

    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public Iterator getPropertyKeys() {
        return this.properties.keySet().iterator();
    }

    protected void addCustomPropertyName(String name) {
        this.customPropertyNames.add(name);
    }

    protected boolean isCustomProperty(String name) {
        return this.customPropertyNames.contains(name);
    }

    public void setup(String namespaceURI, String localName, String qName, Attributes attributes, JsfConfig jsfConfig) {
        this.setupProperties(attributes);
        this.renameProperties();
        this.processInject(jsfConfig);
    }

    protected void setupProperties(Attributes attributes) {
        if (attributes == null) {
            return;
        }
        int length = attributes.getLength();
        int i = 0;
        while (i < length) {
            if ("http://www.seasar.org/maya".equals(attributes.getURI(i))) {
                this.properties.put(attributes.getLocalName(i), attributes.getValue(i));
            } else if (this.properties.get(attributes.getQName(i)) == null) {
                this.properties.put(attributes.getQName(i), attributes.getValue(i));
            }
            ++i;
        }
    }

    protected void renameProperties() {
        this.renameProperty("class", "styleClass");
    }

    protected void renameProperty(String from, String to) {
        if (this.properties.containsKey(from)) {
            Object value = this.properties.remove(from);
            this.properties.put(to, value);
        }
    }

    protected void processInject(JsfConfig jsfConfig) {
        String inject = this.getProperty("inject");
        if (inject != null) {
            TagConfig tagConfig = jsfConfig.getTagConfig(inject);
            this.setTagClass(tagConfig.getTagClass());
        }
    }

    protected Class getTagClass() {
        return this.tagClass;
    }

    protected void setTagClass(Class tagClass) {
        this.tagClass = tagClass;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public TagProcessor getChild(int index) {
        return (TagProcessor)this.children.get(index);
    }

    public void addChild(TagProcessor child) {
        this.children.add(child);
        child.setParent(this);
    }

    public TagProcessor getParent() {
        return this.parent;
    }

    public void setParent(TagProcessor parent) {
        this.parent = parent;
    }

    public void process(JsfContext jsfContext, Tag parentTag) throws JspException {
        if (this.tagClass == null) {
            return;
        }
        Tag tag = (Tag)ClassUtil.newInstance((Class)this.tagClass);
        try {
            this.process(jsfContext, tag, parentTag);
        }
        finally {
            tag.release();
        }
    }

    protected void process(JsfContext jsfContext, Tag tag, Tag parentTag) throws JspException {
        if (parentTag != null) {
            tag.setParent(parentTag);
        }
        tag.setPageContext(jsfContext.getPageContext());
        this.setProperties(tag, jsfContext);
        if (tag instanceof BodyTag) {
            this.processBodyTag(jsfContext, (BodyTag)tag);
        } else if (tag instanceof IterationTag) {
            this.processIterationTag(jsfContext, (IterationTag)tag);
        } else {
            this.processTag(jsfContext, tag);
        }
    }

    protected void processTag(JsfContext pagesContext, Tag tag) throws JspException {
        if (tag.doStartTag() != 0) {
            this.processChildren(pagesContext, tag);
            tag.doEndTag();
        }
    }

    protected void processBodyTag(JsfContext jsfContext, BodyTag tag) throws JspException {
        int evalDoStartTag = tag.doStartTag();
        if (evalDoStartTag != 0) {
            PageContext pageContext = null;
            if (1 != evalDoStartTag) {
                pageContext = jsfContext.getPageContext();
                BodyContent bodyContent = pageContext.pushBody();
                tag.setBodyContent(bodyContent);
                tag.doInitBody();
            }
            do {
                this.processChildren(jsfContext, (Tag)tag);
            } while (2 == tag.doAfterBody());
            if (pageContext != null) {
                pageContext.popBody();
            }
        }
        tag.doEndTag();
    }

    protected void processIterationTag(JsfContext jsfContext, IterationTag tag) throws JspException {
        int evalDoStartTag = tag.doStartTag();
        if (evalDoStartTag != 0) {
            do {
                this.processChildren(jsfContext, (Tag)tag);
            } while (2 == tag.doAfterBody());
        }
        tag.doEndTag();
    }

    protected void processChildren(JsfContext jsfContext, Tag parentTag) throws JspException {
        int i = 0;
        while (i < this.getChildCount()) {
            TagProcessor child = this.getChild(i);
            child.process(jsfContext, parentTag);
            ++i;
        }
    }

    public TagProcessor findAncestor(Class clazz) {
        if (this.parent == null) {
            return null;
        }
        if (clazz.isInstance(this.parent)) {
            return this.parent;
        }
        return this.parent.findAncestor(clazz);
    }

    protected Map getInsertProcessorMap(PageContext pageContext) {
        HashMap map = (HashMap)pageContext.getAttribute(INSERT_PROCESSOR_MAP_ATTR);
        if (map == null) {
            map = new HashMap();
            pageContext.setAttribute(INSERT_PROCESSOR_MAP_ATTR, map);
        }
        return map;
    }
}

