/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dataset.impl;

import java.sql.Connection;
import javax.sql.DataSource;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.RowState;
import org.seasar.extension.dataset.TableWriter;
import org.seasar.framework.util.ConnectionUtil;
import org.seasar.framework.util.DataSourceUtil;

public class SqlTableWriter
implements TableWriter {
    private DataSource dataSource_;

    public SqlTableWriter(DataSource dataSource) {
        this.dataSource_ = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource_;
    }

    public void write(DataTable table) {
        if (!table.hasMetaData()) {
            this.setupMetaData(table);
        }
        this.doWrite(table);
    }

    protected void doWrite(DataTable table) {
        int i = 0;
        while (i < table.getRowSize()) {
            DataRow row = table.getRow(i);
            RowState state = row.getState();
            state.update(this.dataSource_, row);
            ++i;
        }
    }

    private void setupMetaData(DataTable table) {
        Connection con = DataSourceUtil.getConnection((DataSource)this.dataSource_);
        try {
            table.setupMetaData(ConnectionUtil.getMetaData((Connection)con));
        }
        finally {
            ConnectionUtil.close((Connection)con);
        }
    }
}

