/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.javassist;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.LoaderClassPath;

public class ClassPoolUtil {
    protected static final Map classPoolMap = Collections.synchronizedMap(new WeakHashMap());
    static /* synthetic */ Class class$0;

    public static ClassPool getClassPool() {
        ClassLoader classLoader = ClassPoolUtil.getClassLoader();
        ClassPool classPool = (ClassPool)classPoolMap.get(classLoader);
        if (classPool == null) {
            if (classLoader == null) {
                return ClassPool.getDefault();
            }
            classPool = new ClassPool();
            classPool.appendClassPath((ClassPath)new LoaderClassPath(classLoader));
            classPoolMap.put(classLoader, classPool);
        }
        return classPool;
    }

    protected static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            return classLoader;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.framework.aop.javassist.ClassPoolUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((classLoader = clazz.getClassLoader()) != null) {
            return classLoader;
        }
        return null;
    }
}

