/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import org.aopalliance.intercept.MethodInterceptor;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.impl.AspectDefImpl;
import org.seasar.framework.util.StringUtil;

public class AspectDefFactory {
    protected AspectDefFactory() {
    }

    public static AspectDef createAspectDef(String interceptorName, String pointcutStr) {
        Pointcut pointcut = AspectDefFactory.createPointcut(pointcutStr);
        AspectDefImpl aspectDef = new AspectDefImpl(pointcut);
        aspectDef.setExpression(interceptorName);
        return aspectDef;
    }

    public static AspectDef createAspectDef(MethodInterceptor interceptor, String pointcutStr) {
        Pointcut pointcut = AspectDefFactory.createPointcut(pointcutStr);
        AspectDefImpl aspectDef = new AspectDefImpl(pointcut);
        aspectDef.setValue(interceptor);
        return aspectDef;
    }

    public static Pointcut createPointcut(String pointcutStr) {
        if (!StringUtil.isEmpty(pointcutStr)) {
            String[] methodNames = StringUtil.split(pointcutStr, ", \n");
            return new PointcutImpl(methodNames);
        }
        return null;
    }
}

