/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.backport175.reader;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.codehaus.backport175.reader.Annotation;
import org.codehaus.backport175.reader.bytecode.AnnotationReader;

public final class Annotations {
    public static boolean isAnnotationPresent(Class annotationType, Class target) {
        return AnnotationReader.getReaderFor(target).isAnnotationPresent(Annotations.getAnnnotationName(annotationType));
    }

    public static Annotation[] getAnnotations(Class target) {
        return AnnotationReader.getReaderFor(target).getAnnotations();
    }

    public static Annotation getAnnotation(Class annotationType, Class target) {
        AnnotationReader reader = AnnotationReader.getReaderFor(target);
        return reader.getAnnotation(Annotations.getAnnnotationName(annotationType));
    }

    public static boolean isAnnotationPresent(Class annotationType, Method method) {
        AnnotationReader reader = AnnotationReader.getReaderFor(method.getDeclaringClass());
        return reader.isAnnotationPresent(Annotations.getAnnnotationName(annotationType), method);
    }

    public static Annotation[] getAnnotations(Method method) {
        return AnnotationReader.getReaderFor(method.getDeclaringClass()).getAnnotations(method);
    }

    public static Annotation getAnnotation(Class annotationType, Method method) {
        AnnotationReader reader = AnnotationReader.getReaderFor(method.getDeclaringClass());
        return reader.getAnnotation(Annotations.getAnnnotationName(annotationType), method);
    }

    public static boolean isAnnotationPresent(Class annotationType, Constructor constructor) {
        AnnotationReader reader = AnnotationReader.getReaderFor(constructor.getDeclaringClass());
        return reader.isAnnotationPresent(Annotations.getAnnnotationName(annotationType), constructor);
    }

    public static Annotation[] getAnnotations(Constructor constructor) {
        return AnnotationReader.getReaderFor(constructor.getDeclaringClass()).getAnnotations(constructor);
    }

    public static Annotation getAnnotation(Class annotationType, Constructor constructor) {
        AnnotationReader reader = AnnotationReader.getReaderFor(constructor.getDeclaringClass());
        return reader.getAnnotation(Annotations.getAnnnotationName(annotationType), constructor);
    }

    public static boolean isAnnotationPresent(Class annotationType, Field field) {
        AnnotationReader reader = AnnotationReader.getReaderFor(field.getDeclaringClass());
        return reader.isAnnotationPresent(Annotations.getAnnnotationName(annotationType), field);
    }

    public static Annotation[] getAnnotations(Field field) {
        return AnnotationReader.getReaderFor(field.getDeclaringClass()).getAnnotations(field);
    }

    public static Annotation getAnnotation(Class annotationType, Field field) {
        AnnotationReader reader = AnnotationReader.getReaderFor(field.getDeclaringClass());
        return reader.getAnnotation(Annotations.getAnnnotationName(annotationType), field);
    }

    private static String getAnnnotationName(Class annotationType) {
        return annotationType.getName().replace('/', '.');
    }
}

