/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.mock.servlet;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.seasar.framework.mock.servlet.MockHttpServletRequestImpl;
import org.seasar.framework.mock.servlet.MockRequestDispatcherImpl;
import org.seasar.framework.mock.servlet.MockServletContext;
import org.seasar.framework.util.EnumerationAdapter;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

public class MockServletContextImpl
implements MockServletContext,
Serializable {
    private static final long serialVersionUID = -5626752218858278823L;
    public static final int MAJOR_VERSION = 2;
    public static final int MINOR_VERSION = 4;
    public static final String SERVER_INFO = "seasar/2.0";
    private String path_;
    private Map mimeTypes_ = new HashMap();
    private Map initParameters_ = new HashMap();
    private Map attributes_ = new HashMap();

    public MockServletContextImpl(String path) {
        if (path == null) {
            path = "/";
        }
        this.path_ = path.charAt(0) == '/' ? path : "/" + path;
    }

    public ServletContext getContext(String path) {
        throw new UnsupportedOperationException();
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    public String getMimeType(String file) {
        return (String)this.mimeTypes_.get(file);
    }

    public void addMimeType(String file, String type) {
        this.mimeTypes_.put(file, type);
    }

    public Set getResourcePaths(String path) {
        String[] array;
        File file;
        File src = ResourceUtil.getResourceAsFile(".");
        File root = src.getParentFile();
        if (root.getName().equalsIgnoreCase("WEB-INF")) {
            root = root.getParentFile();
        }
        if (!(file = new File(root, this.adjustPath(path))).exists() && (array = StringUtil.split(path, "/")).length > 1) {
            file = new File(root, array[array.length - 1]);
        }
        if (file.isDirectory()) {
            HashSet<String> paths = new HashSet<String>();
            File[] files = file.listFiles();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    paths.add("file:/" + files[i].getAbsolutePath());
                    ++i;
                }
                return paths;
            }
        }
        return null;
    }

    public URL getResource(String path) throws MalformedURLException {
        if (ResourceUtil.isExist(path = this.adjustPath(path))) {
            return ResourceUtil.getResource(path);
        }
        return new URL(path);
    }

    public InputStream getResourceAsStream(String path) {
        return ResourceUtil.getResourceAsStream(this.adjustPath(path));
    }

    protected String adjustPath(String path) {
        if (path != null && path.length() >= 0 && path.charAt(0) == '/') {
            return path.substring(1);
        }
        return path;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new MockRequestDispatcherImpl();
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        throw new UnsupportedOperationException();
    }

    public Servlet getServlet(String name) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public Enumeration getServlets() {
        throw new UnsupportedOperationException();
    }

    public Enumeration getServletNames() {
        throw new UnsupportedOperationException();
    }

    public void log(String message) {
        System.out.println(message);
    }

    public void log(Exception ex, String message) {
        System.out.println(message);
        ex.printStackTrace();
    }

    public void log(String message, Throwable t) {
        System.out.println(message);
        t.printStackTrace();
    }

    public String getRealPath(String path) {
        return ResourceUtil.getResource(this.adjustPath(path)).getFile();
    }

    public String getServerInfo() {
        return SERVER_INFO;
    }

    public String getInitParameter(String name) {
        return (String)this.initParameters_.get(name);
    }

    public Enumeration getInitParameterNames() {
        return new EnumerationAdapter(this.initParameters_.keySet().iterator());
    }

    public void setInitParameter(String name, String value) {
        this.initParameters_.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes_.get(name);
    }

    public Enumeration getAttributeNames() {
        return new EnumerationAdapter(this.attributes_.keySet().iterator());
    }

    public void setAttribute(String name, Object value) {
        this.attributes_.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes_.remove(name);
    }

    public String getServletContextName() {
        return this.path_;
    }

    public MockHttpServletRequestImpl createRequest(String path) {
        String queryString = null;
        int question = path.indexOf(63);
        if (question >= 0) {
            queryString = path.substring(question + 1);
            path = path.substring(0, question);
        }
        MockHttpServletRequestImpl request = new MockHttpServletRequestImpl(this, path);
        request.setQueryString(queryString);
        return request;
    }
}

