/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.config.rule;

import java.io.File;
import javax.servlet.ServletContext;
import org.apache.struts.action.ActionForward;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.config.AutoStrutsConfigRule;
import org.seasar.struts.config.rule.CommonNamingRule;
import org.seasar.struts.config.rule.ZeroConfigActionRule;

public class ZeroConfigActionRuleImpl
implements ZeroConfigActionRule {
    private static final Logger logger = Logger.getLogger((Class)(class$org$seasar$struts$config$rule$ZeroConfigActionRuleImpl == null ? (class$org$seasar$struts$config$rule$ZeroConfigActionRuleImpl = ZeroConfigActionRuleImpl.class$("org.seasar.struts.config.rule.ZeroConfigActionRuleImpl")) : class$org$seasar$struts$config$rule$ZeroConfigActionRuleImpl));
    private AutoStrutsConfigRule configRule;
    static /* synthetic */ Class class$org$seasar$struts$config$rule$ZeroConfigActionRuleImpl;

    public String getPath(Class actionClass, ModuleConfig config) {
        return this.getActionPathName(actionClass, config);
    }

    public String getName(Class actionClass, ModuleConfig config) {
        String name = this.getActionPathName(actionClass, config).substring(1);
        String formName = name + "Form";
        String dtoName = name + "Dto";
        if (config.findFormBeanConfig(formName) != null) {
            return formName;
        }
        if (config.findFormBeanConfig(dtoName) != null) {
            return dtoName;
        }
        if (config.findFormBeanConfig(name) != null) {
            return name;
        }
        return "";
    }

    private String getActionPathName(Class actionClass, ModuleConfig config) {
        String result = this.getActionComponentName(actionClass);
        if (result == null) {
            result = ClassUtil.getShortClassName((Class)actionClass);
            result = CommonNamingRule.decapitalizeName(result);
        } else if (this.isPathComponentName(result)) {
            return this.toPathComponentName(result, config);
        }
        result = result.replaceFirst("Impl$", "");
        result = result.replaceFirst("Action$", "");
        return "/" + result;
    }

    private String getActionComponentName(Class actionClass) {
        S2Container container = SingletonS2ContainerFactory.getContainer();
        if (!container.hasComponentDef((Object)actionClass)) {
            return null;
        }
        ComponentDef componentDef = container.getComponentDef((Object)actionClass);
        if (componentDef == null) {
            return null;
        }
        return componentDef.getComponentName();
    }

    private boolean isPathComponentName(String componentName) {
        return componentName.startsWith("/");
    }

    private String toPathComponentName(String componentName, ModuleConfig config) {
        return config.getPrefix() + componentName;
    }

    public String getScope(Class actionClass, ModuleConfig config) {
        return "request";
    }

    public boolean getValidate(Class actionClass, ModuleConfig config) {
        return true;
    }

    public String getInput(Class actionClass, ModuleConfig config) {
        return null;
    }

    public String getParameter(Class actionClass, ModuleConfig config) {
        return null;
    }

    public String getAttribute(Class actionClass, ModuleConfig config) {
        return null;
    }

    public String getForward(Class actionClass, ModuleConfig config) {
        return null;
    }

    public String getInclude(Class actionClass, ModuleConfig config) {
        return null;
    }

    public String getPrefix(Class actionClass, ModuleConfig config) {
        return null;
    }

    public String getSuffix(Class actionClass, ModuleConfig config) {
        return null;
    }

    public boolean getUnknown(Class actionClass, ModuleConfig config) {
        return false;
    }

    public String getRoles(Class actionClass, ModuleConfig config) {
        return null;
    }

    public void addFowardConfig(Class actionClass, ActionConfig actionConfig, ServletContext servletContext) {
        ForwardConfig forwardConfig = actionConfig.findForwardConfig("success");
        if (forwardConfig != null) {
            return;
        }
        String path = null;
        String[] viewExtension = this.configRule.getViewExtension();
        for (int i = 0; i < viewExtension.length; ++i) {
            String file = this.getPath(actionClass, null) + "." + viewExtension[i];
            path = this.configRule.getDocRoot() + file;
            String packageDir = "/" + actionClass.getPackage().getName().replace('.', '/');
            path = this.getExistFilePath(this.configRule.getDocRoot(), packageDir, file, actionConfig, servletContext);
            if (path != null) break;
        }
        this.addFowardConfig(path, actionConfig);
    }

    private void addFowardConfig(String path, ActionConfig actionConfig) {
        ActionForward forwardConfig = new ActionForward();
        forwardConfig.setName("success");
        forwardConfig.setPath(path);
        forwardConfig.setRedirect(false);
        actionConfig.addForwardConfig((ForwardConfig)forwardConfig);
    }

    private String getExistFilePath(String docRoot, String packageDir, String file, ActionConfig actionConfig, ServletContext servletContext) {
        String path = docRoot + packageDir + file;
        if (new File(servletContext.getRealPath(path)).exists()) {
            return path;
        }
        if (StringUtil.isEmpty((String)packageDir)) {
            if (this.isLastExtension(file) && actionConfig.findForwardConfigs().length == 0) {
                String message = "View file was not found." + new File(path).getAbsolutePath();
                logger.info((Object)message);
            }
            return null;
        }
        int index = packageDir.indexOf("/", 1);
        packageDir = packageDir.substring(index + 1);
        packageDir = index < 0 ? "" : "/" + packageDir;
        return this.getExistFilePath(docRoot, packageDir, file, actionConfig, servletContext);
    }

    private boolean isLastExtension(String file) {
        return file.endsWith(this.configRule.getViewExtension()[this.configRule.getViewExtension().length - 1]);
    }

    public void setAutoStrutsConfigPattern(AutoStrutsConfigRule configRule) {
        this.configRule = configRule;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

