/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.processor;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.seasar.struts.form.InputValueForm;
import org.seasar.struts.processor.ExternalRequestProcessor;
import org.seasar.struts.processor.InputValueFormProcessor;

public class InputValueFormProcessorImpl
implements InputValueFormProcessor {
    public ActionForm create(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping, ExternalRequestProcessor processor) throws ServletException {
        String attribute = mapping.getAttribute();
        if (attribute == null) {
            return null;
        }
        InputValueForm actionForm = new InputValueForm();
        if ("request".equals(mapping.getScope())) {
            request.setAttribute(attribute, (Object)actionForm);
        } else {
            HttpSession session = request.getSession();
            this.backupSessionForm(session, attribute);
            session.setAttribute(attribute, (Object)actionForm);
        }
        processor.processPopulate(request, response, (ActionForm)actionForm, mapping);
        actionForm.freeze();
        return actionForm;
    }

    public void delete(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) {
        if ("request".equals(mapping.getScope())) {
            request.removeAttribute(mapping.getAttribute());
        } else {
            HttpSession session = request.getSession();
            session.removeAttribute(mapping.getAttribute());
            this.turnbackSessionForm(session, mapping.getAttribute());
        }
    }

    private void backupSessionForm(HttpSession session, String attribute) {
        Object form = session.getAttribute(attribute);
        if (form == null) {
            return;
        }
        if (form instanceof InputValueForm) {
            return;
        }
        session.setAttribute(this.getBackupSessionFormAttribute(attribute), form);
    }

    private void turnbackSessionForm(HttpSession session, String attribute) {
        Object form = session.getAttribute(this.getBackupSessionFormAttribute(attribute));
        session.removeAttribute(this.getBackupSessionFormAttribute(attribute));
        session.setAttribute(attribute, form);
    }

    private String getBackupSessionFormAttribute(String attribute) {
        return "org.seasar.struts.BACKUP_SESSION_FORM." + attribute;
    }
}

