/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl;

import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.maya.FactoryFactory;
import org.seasar.maya.UnifiedFactory;
import org.seasar.maya.cycle.scope.ApplicationScope;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.MarshallUtil;
import org.seasar.maya.impl.cycle.web.ApplicationScopeImpl;
import org.seasar.maya.impl.factory.UnifiedFactoryHandler;
import org.seasar.maya.impl.source.ApplicationSourceDescriptor;
import org.seasar.maya.impl.util.IOUtil;
import org.seasar.maya.impl.util.XMLUtil;
import org.seasar.maya.source.SourceDescriptor;

public class FactoryFactoryImpl
extends FactoryFactory
implements CONST_IMPL {
    private static final long serialVersionUID = -1393736148065197812L;
    private static Log LOG;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.maya.impl.FactoryFactoryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    protected boolean checkInterface(Class clazz) {
        if (clazz != null && clazz.isInterface()) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.seasar.maya.UnifiedFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.isAssignableFrom(clazz)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected UnifiedFactory marshallFactory(Class interfaceClass, Object context, SourceDescriptor source, UnifiedFactory beforeFactory) {
        UnifiedFactory factory;
        if (source == null) {
            throw new IllegalArgumentException();
        }
        String systemID = source.getSystemID();
        if (source.exists()) {
            UnifiedFactoryHandler handler = new UnifiedFactoryHandler(interfaceClass, beforeFactory);
            InputStream stream = source.getInputStream();
            try {
                try {
                    XMLUtil.parse(handler, stream, "-//The Seasar Foundation//DTD Maya Factory 1.0//EN", systemID, true, true, false);
                }
                catch (Throwable t) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("Factory parse error on " + systemID), t);
                    }
                    factory = beforeFactory;
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                IOUtil.close(stream);
                throw throwable;
            }
            {
                Object var10_12 = null;
            }
            IOUtil.close(stream);
            factory = handler.getUnifiedFactory();
        } else {
            factory = beforeFactory;
        }
        if (factory != null) {
            factory.setUnderlyingContext(context);
        }
        return factory;
    }

    protected UnifiedFactory getFactory(Class interfaceClass, Object context) {
        if (!this.checkInterface(interfaceClass) || context == null) {
            throw new IllegalArgumentException();
        }
        String systemID = interfaceClass.getName();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.seasar.maya.impl.factory.UnifiedFactoryHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SourceDescriptor source = MarshallUtil.getDefaultSource(systemID, clazz);
        UnifiedFactory factory = this.marshallFactory(interfaceClass, context, source, null);
        Iterator it = MarshallUtil.iterateMetaInfSources(systemID);
        while (it.hasNext()) {
            source = (SourceDescriptor)it.next();
            factory = this.marshallFactory(interfaceClass, context, source, factory);
        }
        source = FactoryFactoryImpl.getBootstrapSource(systemID);
        factory = this.marshallFactory(interfaceClass, context, source, factory);
        return factory;
    }

    protected ApplicationScope getBootstrapApplication(Object context) {
        ApplicationScopeImpl application = new ApplicationScopeImpl();
        application.setUnderlyingContext(context);
        return application;
    }

    protected SourceDescriptor getBootstrapSource(String systemID, Object context) {
        ApplicationSourceDescriptor appSource = new ApplicationSourceDescriptor();
        appSource.setRoot("/WEB-INF");
        appSource.setSystemID(systemID);
        appSource.setApplicationScope(this.getBootstrapApplication(context));
        return appSource;
    }
}

