/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.engine.specification.NodeTreeWalker;
import org.seasar.maya.impl.cycle.CycleUtil;
import org.seasar.maya.impl.util.AbstractMessagedException;

public abstract class MayaException
extends AbstractMessagedException {
    private static final Log LOG;
    private String _originalSystemID;
    private int _originalLineNumber = -1;
    private String _injectedSystemID;
    private int _injectedLineNumber = -1;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.maya.impl.MayaException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public MayaException() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        if (cycle != null) {
            NodeTreeWalker injected;
            NodeTreeWalker original = cycle.getOriginalNode();
            if (original != null) {
                this._originalSystemID = original.getSystemID();
                this._originalLineNumber = original.getLineNumber();
            }
            if ((injected = cycle.getInjectedNode()) != null) {
                this._injectedSystemID = injected.getSystemID();
                this._injectedLineNumber = injected.getLineNumber();
            }
        }
    }

    protected abstract String[] getMessageParams();

    protected String[] getParamValues() {
        String[] params;
        block3: {
            params = ZERO_PARAM;
            try {
                params = this.getMessageParams();
                if (params == null) {
                    params = ZERO_PARAM;
                }
            }
            catch (Throwable t) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)t.getMessage(), t);
            }
        }
        int paramLength = params.length;
        int magicNumber = 4;
        String[] newParams = new String[paramLength + magicNumber];
        newParams[0] = this._originalSystemID;
        newParams[1] = Integer.toString(this._originalLineNumber);
        newParams[2] = this._injectedSystemID;
        newParams[3] = Integer.toString(this._injectedLineNumber);
        System.arraycopy(params, 0, newParams, magicNumber, paramLength);
        return newParams;
    }

    public String getOriginalSystemID() {
        return this._originalSystemID;
    }

    public int getOriginalLineNumber() {
        return this._originalLineNumber;
    }

    public String getInjectedSystemID() {
        return this._injectedSystemID;
    }

    public int getInjectedLineNumber() {
        return this._injectedLineNumber;
    }
}

