/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder;

import java.util.Iterator;
import org.seasar.maya.engine.specification.Namespace;
import org.seasar.maya.engine.specification.NodeAttribute;
import org.seasar.maya.engine.specification.PrefixAwareName;
import org.seasar.maya.engine.specification.PrefixMapping;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.engine.specification.SpecificationNode;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.builder.IllegalNameException;
import org.seasar.maya.impl.builder.PrefixMappingNotFoundException;
import org.seasar.maya.impl.engine.specification.SpecificationUtil;
import org.seasar.maya.impl.util.StringUtil;

public class BuilderUtil
implements CONST_IMPL {
    private BuilderUtil() {
    }

    public static SpecificationNode createInjectedNode(QName qName, String uri, SpecificationNode original, boolean maya) {
        if (qName == null || original == null) {
            throw new IllegalArgumentException();
        }
        String systemID = original.getSystemID();
        int lineNumber = original.getLineNumber();
        boolean onTemplate = original.isOnTemplate();
        int sequenceID = original.getSequenceID();
        SpecificationNode node = SpecificationUtil.createSpecificationNode(qName, systemID, lineNumber, onTemplate, sequenceID);
        if (StringUtil.hasValue(uri)) {
            Iterator it = original.iterateAttribute();
            while (it.hasNext()) {
                NodeAttribute attr = (NodeAttribute)it.next();
                String attrURI = attr.getQName().getNamespaceURI();
                if (!uri.equals(attrURI) && (!maya || !"http://maya.seasar.org".equals(attrURI))) continue;
                node.addAttribute(attr.getQName(), attr.getValue());
            }
        }
        node.setParentSpace(original.getParentSpace());
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PrefixAwareName parseName(Namespace namespace, String qName) {
        PrefixMapping mapping;
        String[] parsed = qName.split(":");
        String prefix = null;
        String localName = null;
        String namespaceURI = null;
        if (parsed.length == 2) {
            prefix = parsed[0];
            localName = parsed[1];
            mapping = namespace.getMappingFromPrefix(prefix, true);
            if (mapping == null) {
                throw new PrefixMappingNotFoundException(prefix);
            }
            namespaceURI = mapping.getNamespaceURI();
        } else {
            if (parsed.length != 1) throw new IllegalNameException(qName);
            localName = parsed[0];
            mapping = namespace.getMappingFromPrefix("", true);
            if (mapping == null) throw new PrefixMappingNotFoundException("");
            namespaceURI = mapping.getNamespaceURI();
        }
        PrefixAwareName ret = SpecificationUtil.createPrefixAwareName(SpecificationUtil.createQName(namespaceURI, localName));
        ret.setParentSpace(namespace);
        return ret;
    }
}

