/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.engine.Template;
import org.seasar.maya.engine.specification.Namespace;
import org.seasar.maya.engine.specification.NodeTreeWalker;
import org.seasar.maya.engine.specification.PrefixAwareName;
import org.seasar.maya.engine.specification.PrefixMapping;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.engine.specification.Specification;
import org.seasar.maya.engine.specification.SpecificationNode;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.builder.BuilderUtil;
import org.seasar.maya.impl.builder.parser.AdditionalHandler;
import org.seasar.maya.impl.cycle.CycleUtil;
import org.seasar.maya.impl.engine.specification.SpecificationUtil;
import org.seasar.maya.impl.util.StringUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public class SpecificationNodeHandler
implements EntityResolver,
DTDHandler,
ContentHandler,
ErrorHandler,
LexicalHandler,
AdditionalHandler,
CONST_IMPL {
    private static final Log LOG;
    protected static final QName QM_DATA;
    protected static final QName QM_PUBLIC_ID;
    protected static final QName QM_SYSTEM_ID;
    protected static final QName QM_TARGET;
    private Specification _specification;
    private NodeTreeWalker _current;
    private Locator _locator;
    private Namespace _namespace;
    private StringBuffer _charactersBuffer;
    private boolean _outputWhitespace = true;
    private boolean _onTemplate;
    private int _inEntity;
    private int _sequenceID;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.maya.impl.builder.SpecificationNodeHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        QM_DATA = SpecificationUtil.createQName("data");
        QM_PUBLIC_ID = SpecificationUtil.createQName("publicID");
        QM_SYSTEM_ID = SpecificationUtil.createQName("systemID");
        QM_TARGET = SpecificationUtil.createQName("target");
    }

    public SpecificationNodeHandler(Specification specification) {
        if (specification == null) {
            throw new IllegalArgumentException();
        }
        this._specification = specification;
        this._onTemplate = specification instanceof Template;
    }

    public void setOutputWhitespace(boolean outputWhitespace) {
        this._outputWhitespace = outputWhitespace;
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    protected void initNamespace() {
        this._namespace = SpecificationUtil.createNamespace();
        this._namespace.addPrefixMapping("", "http://www.w3.org/TR/html4");
    }

    protected void pushNamespace() {
        Namespace parentSpace = this._namespace;
        this._namespace = SpecificationUtil.createNamespace();
        this._namespace.setParentSpace(parentSpace);
    }

    protected void popNamespace() {
        this._namespace = this._namespace.getParentSpace();
        if (this._namespace == null) {
            throw new IllegalStateException();
        }
    }

    public void startDocument() {
        this._sequenceID = 1;
        this._charactersBuffer = new StringBuffer(128);
        this._current = this._specification;
        this.initNamespace();
        this.pushNamespace();
    }

    public void startPrefixMapping(String prefix, String uri) {
        this._namespace.addPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) {
        PrefixMapping mapping = this._namespace.getMappingFromPrefix(prefix, false);
        if (mapping == null) {
            throw new IllegalStateException();
        }
    }

    protected SpecificationNode addNode(QName qName) {
        String systemID = this._locator.getSystemId();
        int lineNumber = this._locator.getLineNumber();
        SpecificationNode child = SpecificationUtil.createSpecificationNode(qName, systemID, lineNumber, this._onTemplate, this._sequenceID);
        ++this._sequenceID;
        child.setParentSpace(this._namespace);
        this._current.addChildNode(child);
        return child;
    }

    protected void addCharactersNode() {
        if (this._charactersBuffer.length() > 0) {
            SpecificationNode node = this.addNode(QM_CHARACTERS);
            String characters = this._charactersBuffer.toString();
            if (!this._outputWhitespace) {
                characters = this.removeIgnorableWhitespace(characters);
            }
            node.addAttribute(QM_TEXT, characters);
            this._charactersBuffer = new StringBuffer(128);
        }
    }

    private String removeIgnorableWhitespace(String characters) {
        StringBuffer buffer = new StringBuffer(characters.length());
        String[] line = characters.split("\n");
        int i = 0;
        while (i < line.length) {
            if (line[i].trim().length() > 0) {
                String token = line[i].replaceAll("^[ \t]+", "");
                token = token.replaceAll("[ \t]+$", "");
                buffer.append(token.replaceAll("[ \t]+", " "));
                buffer.append("\n");
            } else if (i == 0) {
                buffer.append("\n");
            }
            ++i;
        }
        return buffer.toString();
    }

    protected void saveToCycle(NodeTreeWalker originalNode) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.setOriginalNode(originalNode);
    }

    protected boolean checkAttribute(String qName, String value) {
        String prefix;
        if (StringUtil.isEmpty(qName)) {
            throw new IllegalArgumentException();
        }
        if ("xmlns".equals(qName)) {
            prefix = "";
        } else if (qName.startsWith("xmlns:")) {
            prefix = qName.substring(6);
        } else {
            return true;
        }
        if (this._namespace.getMappingFromPrefix(prefix, false) == null) {
            this.startPrefixMapping(prefix, value);
        }
        if (LOG.isWarnEnabled()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.seasar.maya.impl.builder.SpecificationNodeHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LOG.warn((Object)StringUtil.getMessage(clazz, 0, prefix, value));
        }
        return false;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
        this.addCharactersNode();
        PrefixAwareName parsedName = BuilderUtil.parseName(this._namespace, qName);
        QName nodeQName = parsedName.getQName();
        String nodeURI = nodeQName.getNamespaceURI();
        SpecificationNode node = this.addNode(nodeQName);
        Namespace elementNS = SpecificationUtil.createNamespace();
        elementNS.setParentSpace(this._namespace);
        elementNS.addPrefixMapping("", nodeURI);
        int i = 0;
        while (i < attributes.getLength()) {
            String attrValue;
            String attrName = attributes.getQName(i);
            if (this.checkAttribute(attrName, attrValue = attributes.getValue(i))) {
                PrefixAwareName parsedAttrName = BuilderUtil.parseName(elementNS, attrName);
                QName attrQName = parsedAttrName.getQName();
                node.addAttribute(attrQName, attrValue);
            }
            ++i;
        }
        this._current = node;
        this.saveToCycle(this._current);
        this.pushNamespace();
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        this.popNamespace();
        this.addCharactersNode();
        this._current = this._current.getParentNode();
        this.saveToCycle(this._current);
    }

    public void endDocument() {
        this.saveToCycle(this._specification);
    }

    public void characters(char[] buffer, int start, int length) {
        if (this._inEntity == 0) {
            this._charactersBuffer.append(buffer, start, length);
        }
    }

    public void ignorableWhitespace(char[] buffer, int start, int length) {
        this._charactersBuffer.append(buffer, start, length);
    }

    public void xmlDecl(String version, String encoding, String standalone) {
        this.addCharactersNode();
        SpecificationNode node = this.addNode(QM_PI);
        node.addAttribute(QM_TARGET, "xml");
        StringBuffer buffer = new StringBuffer();
        if (StringUtil.hasValue(version)) {
            buffer.append("version=\"").append(version).append("\" ");
        }
        if (StringUtil.hasValue(encoding)) {
            buffer.append("encoding=\"").append(encoding).append("\" ");
        }
        if (StringUtil.hasValue(standalone)) {
            buffer.append("standalone=\"").append(standalone).append("\" ");
        }
        if (buffer.length() > 0) {
            node.addAttribute(QM_DATA, buffer.toString());
        }
    }

    public void processingInstruction(String target, String data) {
        this.addCharactersNode();
        SpecificationNode node = this.addNode(QM_PI);
        node.addAttribute(QM_TARGET, target);
        if (StringUtil.hasValue(data)) {
            node.addAttribute(QM_DATA, data);
        }
    }

    public void skippedEntity(String name) {
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        return null;
    }

    public void startEntity(String name) {
        String entityRef = "&" + name + ";";
        this._charactersBuffer.append(entityRef);
        ++this._inEntity;
    }

    public void endEntity(String name) {
        --this._inEntity;
    }

    public void comment(char[] buffer, int start, int length) {
        if (!this._specification.getSystemID().endsWith(".maya")) {
            this.addCharactersNode();
            String comment = new String(buffer, start, length);
            SpecificationNode node = this.addNode(QM_COMMENT);
            node.addAttribute(QM_TEXT, comment);
        }
    }

    public void notationDecl(String name, String publicId, String systemId) {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
    }

    public void startDTD(String name, String publicID, String systemID) {
        this.addCharactersNode();
        SpecificationNode node = this.addNode(QM_DOCTYPE);
        node.addAttribute(QM_NAME, name);
        if (StringUtil.hasValue(publicID)) {
            node.addAttribute(QM_PUBLIC_ID, publicID);
        }
        if (StringUtil.hasValue(systemID)) {
            node.addAttribute(QM_SYSTEM_ID, systemID);
        }
        this._charactersBuffer.append("\r\n");
    }

    public void endDTD() {
    }

    public void startCDATA() {
        this.addCharactersNode();
        SpecificationNode node = this.addNode(QM_CDATA);
        this._current = node;
    }

    public void endCDATA() {
        this.addCharactersNode();
        this._current = this._current.getParentNode();
    }

    public void warning(SAXParseException e) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)e);
        }
    }

    public void fatalError(SAXParseException e) {
        if (LOG.isFatalEnabled()) {
            LOG.fatal((Object)e);
        }
        throw new RuntimeException(e);
    }

    public void error(SAXParseException e) {
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)e);
        }
        throw new RuntimeException(e);
    }
}

