/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.seasar.maya.builder.TemplateBuilder;
import org.seasar.maya.builder.injection.InjectionChain;
import org.seasar.maya.builder.injection.InjectionResolver;
import org.seasar.maya.builder.library.LibraryManager;
import org.seasar.maya.builder.library.ProcessorDefinition;
import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.cycle.scope.ApplicationScope;
import org.seasar.maya.cycle.script.CompiledScript;
import org.seasar.maya.engine.Template;
import org.seasar.maya.engine.processor.ProcessorTreeWalker;
import org.seasar.maya.engine.processor.TemplateProcessor;
import org.seasar.maya.engine.specification.NodeTreeWalker;
import org.seasar.maya.engine.specification.PrefixMapping;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.engine.specification.Specification;
import org.seasar.maya.engine.specification.SpecificationNode;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.builder.ProcessorNotInjectedException;
import org.seasar.maya.impl.builder.SpecificationBuilderImpl;
import org.seasar.maya.impl.builder.TemplateNodeNotResolvedException;
import org.seasar.maya.impl.builder.TooManyDoBodyException;
import org.seasar.maya.impl.builder.injection.DefaultInjectionChain;
import org.seasar.maya.impl.builder.parser.AdditionalHandler;
import org.seasar.maya.impl.builder.parser.TemplateParser;
import org.seasar.maya.impl.builder.parser.TemplateScanner;
import org.seasar.maya.impl.cycle.CycleUtil;
import org.seasar.maya.impl.engine.processor.AttributeProcessor;
import org.seasar.maya.impl.engine.processor.CharactersProcessor;
import org.seasar.maya.impl.engine.processor.DoBodyProcessor;
import org.seasar.maya.impl.engine.processor.ElementProcessor;
import org.seasar.maya.impl.engine.specification.SpecificationUtil;
import org.seasar.maya.impl.provider.ProviderUtil;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.impl.util.xml.XMLReaderPool;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TemplateBuilderImpl
extends SpecificationBuilderImpl
implements TemplateBuilder,
CONST_IMPL {
    private static final long serialVersionUID = -1031702086020145692L;
    private List _resolvers = new ArrayList();
    private HtmlReaderPool _htmlReaderPool = new HtmlReaderPool();
    private InjectionChain _chain = new DefaultInjectionChain();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInjectionResolver(InjectionResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException();
        }
        List list = this._resolvers;
        synchronized (list) {
            this._resolvers.add(resolver);
        }
    }

    protected List getInjectionResolvers() {
        return Collections.unmodifiableList(this._resolvers);
    }

    protected boolean isHTML(String mimeType) {
        return mimeType != null && mimeType.indexOf("html") != -1;
    }

    protected XMLReaderPool getXMLReaderPool(String systemID) {
        ApplicationScope application = CycleUtil.getServiceCycle().getApplicationScope();
        String mimeType = application.getMimeType(systemID);
        if (this.isHTML(mimeType)) {
            return this._htmlReaderPool;
        }
        return super.getXMLReaderPool(systemID);
    }

    protected String getPublicID() {
        return "http://maya.seasar.org/template";
    }

    protected void afterBuild(Specification specification) {
        if (!(specification instanceof Template)) {
            throw new IllegalArgumentException();
        }
        this.doInjection((Template)specification);
    }

    protected void saveToCycle(NodeTreeWalker originalNode, NodeTreeWalker injectedNode) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.setOriginalNode(originalNode);
        cycle.setInjectedNode(injectedNode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected TemplateProcessor findConnectPoint(TemplateProcessor processor) {
        if (processor instanceof ElementProcessor && ((ElementProcessor)processor).isDuplicated()) {
            return this.findConnectPoint((TemplateProcessor)processor.getChildProcessor(0));
        }
        int i = 0;
        while (i < processor.getChildProcessorSize()) {
            ProcessorTreeWalker child = processor.getChildProcessor(i);
            if (child instanceof CharactersProcessor) {
                CharactersProcessor charsProc = (CharactersProcessor)child;
                CompiledScript script = charsProc.getText().getValue();
                if (!script.isLiteral()) return null;
                String value = script.getScriptText();
                if (StringUtil.hasValue(value.trim())) {
                    return null;
                }
            } else if (!(child instanceof AttributeProcessor)) {
                return null;
            }
            ++i;
        }
        return processor;
    }

    protected TemplateProcessor createProcessor(SpecificationNode original, SpecificationNode injected) {
        QName name = injected.getQName();
        LibraryManager libraryManager = ProviderUtil.getLibraryManager();
        ProcessorDefinition def = libraryManager.getProcessorDefinition(name);
        if (def != null) {
            TemplateProcessor proc = def.createTemplateProcessor(injected);
            proc.setOriginalNode(original);
            proc.setInjectedNode(injected);
            return proc;
        }
        return null;
    }

    protected InjectionChain getDefaultInjectionChain() {
        return this._chain;
    }

    protected TemplateProcessor resolveInjectedNode(Template template, Stack stack, SpecificationNode original, SpecificationNode injected) {
        if (injected == null) {
            throw new IllegalArgumentException();
        }
        this.saveToCycle(original, injected);
        TemplateProcessor processor = this.createProcessor(original, injected);
        if (processor == null) {
            PrefixMapping mapping = original.getMappingFromPrefix("", true);
            if (mapping == null) {
                throw new IllegalStateException();
            }
            String defaultURI = mapping.getNamespaceURI();
            if (defaultURI.equals(injected.getQName().getNamespaceURI())) {
                InjectionChain chain = this.getDefaultInjectionChain();
                SpecificationNode retry = chain.getNode(injected);
                processor = this.createProcessor(original, retry);
            }
            if (processor == null) {
                throw new ProcessorNotInjectedException(injected.toString());
            }
        }
        ProcessorTreeWalker parent = (ProcessorTreeWalker)stack.peek();
        parent.addChildProcessor(processor);
        Iterator it = injected.iterateChildNode();
        if (!it.hasNext()) {
            return processor;
        }
        stack.push(processor);
        TemplateProcessor connectionPoint = null;
        while (it.hasNext()) {
            SpecificationNode childNode = (SpecificationNode)it.next();
            this.saveToCycle(original, childNode);
            TemplateProcessor childProcessor = this.resolveInjectedNode(template, stack, original, childNode);
            if (!(childProcessor instanceof DoBodyProcessor)) continue;
            if (connectionPoint != null) {
                throw new TooManyDoBodyException();
            }
            connectionPoint = childProcessor;
        }
        stack.pop();
        this.saveToCycle(original, injected);
        if (connectionPoint != null) {
            return connectionPoint;
        }
        return this.findConnectPoint(processor);
    }

    protected SpecificationNode resolveOriginalNode(SpecificationNode original, InjectionChain chain) {
        if (original == null || chain == null) {
            throw new IllegalArgumentException();
        }
        if (this._resolvers.size() > 0) {
            InjectionChainImpl first = new InjectionChainImpl(chain);
            return first.getNode(original);
        }
        return chain.getNode(original);
    }

    protected void walkParsedTree(Template template, Stack stack, NodeTreeWalker original) {
        if (original == null) {
            throw new IllegalArgumentException();
        }
        Iterator it = original.iterateChildNode();
        while (it.hasNext()) {
            SpecificationNode child = (SpecificationNode)it.next();
            this.saveToCycle(child, child);
            if (QM_MAYA.equals(child.getQName())) continue;
            InjectionChain chain = this.getDefaultInjectionChain();
            SpecificationNode injected = this.resolveOriginalNode(child, chain);
            if (injected == null) {
                throw new TemplateNodeNotResolvedException(original.toString());
            }
            this.saveToCycle(child, injected);
            TemplateProcessor processor = this.resolveInjectedNode(template, stack, child, injected);
            if (processor == null) continue;
            stack.push(processor);
            this.walkParsedTree(template, stack, child);
            stack.pop();
        }
    }

    protected void doInjection(Template template) {
        if (template == null) {
            throw new IllegalArgumentException();
        }
        this.saveToCycle(template, template);
        Stack<Template> stack = new Stack<Template>();
        stack.push(template);
        SpecificationNode maya = SpecificationUtil.createSpecificationNode(QM_MAYA, template.getSystemID(), 0, true, 0);
        template.addChildNode(maya);
        this.walkParsedTree(template, stack, template);
        if (!template.equals(stack.peek())) {
            throw new IllegalStateException();
        }
        this.saveToCycle(template, template);
    }

    protected class HtmlReaderPool
    extends XMLReaderPool {
        private static final long serialVersionUID = -5203349759797583368L;

        protected HtmlReaderPool() {
        }

        protected Object createObject() {
            return new TemplateParser(new TemplateScanner());
        }

        protected boolean validateObject(Object object) {
            return object instanceof TemplateParser;
        }

        public XMLReader borrowXMLReader(ContentHandler handler, boolean namespaces, boolean validation, boolean xmlSchema) {
            XMLReader htmlReader = super.borrowXMLReader(handler, namespaces, validation, xmlSchema);
            if (handler instanceof AdditionalHandler) {
                try {
                    htmlReader.setProperty("org.seasar.maya.impl.builder.parser.AdditionalHandler", handler);
                }
                catch (SAXException e) {
                    throw new RuntimeException(e);
                }
            }
            return htmlReader;
        }
    }

    protected class InjectionChainImpl
    implements InjectionChain {
        private int _index;
        private InjectionChain _external;

        public InjectionChainImpl(InjectionChain external) {
            this._external = external;
        }

        public SpecificationNode getNode(SpecificationNode original) {
            if (original == null) {
                throw new IllegalArgumentException();
            }
            if (this._index < TemplateBuilderImpl.this.getInjectionResolvers().size()) {
                InjectionResolver resolver = (InjectionResolver)TemplateBuilderImpl.this.getInjectionResolvers().get(this._index);
                ++this._index;
                InjectionChain chain = this._index == TemplateBuilderImpl.this.getInjectionResolvers().size() ? this._external : this;
                return resolver.getNode(original, chain);
            }
            throw new IndexOutOfBoundsException();
        }
    }
}

