/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder.injection;

import org.seasar.maya.builder.injection.InjectionChain;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.engine.specification.SpecificationNode;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.builder.BuilderUtil;
import org.seasar.maya.impl.util.StringUtil;

public class DefaultInjectionChain
implements InjectionChain,
CONST_IMPL {
    private QName[] _specialNames = new QName[]{QM_CDATA, QM_CHARACTERS, QM_COMMENT, QM_DOCTYPE, QM_PI};

    protected QName[] getSpecialNames() {
        return this._specialNames;
    }

    protected boolean isSpecialNode(QName qName) {
        QName[] specialNames = this.getSpecialNames();
        int i = 0;
        while (i < specialNames.length) {
            if (specialNames[i].equals(qName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public SpecificationNode getNode(SpecificationNode original) {
        if (original == null) {
            throw new IllegalArgumentException();
        }
        if (this.isSpecialNode(original.getQName())) {
            return original.copyTo();
        }
        QName qName = original.getQName();
        String uri = qName.getNamespaceURI();
        SpecificationNode element = BuilderUtil.createInjectedNode(QM_TEMPLATE_ELEMENT, uri, original, false);
        StringBuffer name = new StringBuffer();
        String prefix = original.getPrefix();
        if (StringUtil.hasValue(prefix)) {
            name.append(prefix).append(":");
        }
        name.append(qName.getLocalName());
        element.addAttribute(QM_NAME, name.toString());
        return element;
    }
}

