/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder.injection;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.maya.builder.injection.InjectionChain;
import org.seasar.maya.builder.injection.InjectionResolver;
import org.seasar.maya.engine.specification.CopyToFilter;
import org.seasar.maya.engine.specification.NodeAttribute;
import org.seasar.maya.engine.specification.NodeObject;
import org.seasar.maya.engine.specification.PrefixAwareName;
import org.seasar.maya.engine.specification.Specification;
import org.seasar.maya.engine.specification.SpecificationNode;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.engine.EngineUtil;
import org.seasar.maya.impl.engine.specification.SpecificationUtil;
import org.seasar.maya.impl.util.ObjectUtil;
import org.seasar.maya.impl.util.StringUtil;

public class EqualsIDInjectionResolver
extends ParameterAwareImpl
implements InjectionResolver,
CONST_IMPL {
    private static final Log LOG;
    private CopyToFilter _idFilter = new CheckIDCopyToFilter();
    private boolean _reportResolvedID = true;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.maya.impl.builder.injection.EqualsIDInjectionResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    protected CopyToFilter getCopyToFilter() {
        return this._idFilter;
    }

    protected boolean isReportResolvedID() {
        return this._reportResolvedID;
    }

    protected String getID(SpecificationNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        NodeAttribute attr = node.getAttribute(QM_ID);
        if (attr != null) {
            return attr.getValue();
        }
        attr = node.getAttribute(QX_ID);
        if (attr != null) {
            return attr.getValue();
        }
        attr = node.getAttribute(QH_ID);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    protected SpecificationNode getEqualsIDNode(SpecificationNode node, String id) {
        if (node == null || StringUtil.isEmpty(id)) {
            throw new IllegalArgumentException();
        }
        Iterator it = node.iterateChildNode();
        while (it.hasNext()) {
            SpecificationNode child = (SpecificationNode)it.next();
            if (id.equals(SpecificationUtil.getAttributeValue(child, QM_ID))) {
                return child;
            }
            SpecificationNode ret = this.getEqualsIDNode(child, id);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public SpecificationNode getNode(SpecificationNode original, InjectionChain chain) {
        if (original == null || chain == null) {
            throw new IllegalArgumentException();
        }
        String id = this.getID(original);
        if (StringUtil.hasValue(id)) {
            Specification spec = SpecificationUtil.findSpecification(original);
            PrefixAwareName injected = null;
            while (spec != null) {
                SpecificationNode maya = SpecificationUtil.getMayaNode(spec);
                if (maya != null && (injected = this.getEqualsIDNode(maya, id)) != null) break;
                spec = EngineUtil.getParentSpecification(spec);
            }
            if (injected != null) {
                if (QM_IGNORE.equals(injected.getQName())) {
                    return chain.getNode(original);
                }
                return injected.copyTo(this.getCopyToFilter());
            }
            if (this.isReportResolvedID() && LOG.isWarnEnabled()) {
                String systemID = original.getSystemID();
                String lineNumber = Integer.toString(original.getLineNumber());
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.seasar.maya.impl.builder.injection.EqualsIDInjectionResolver");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                String msg = StringUtil.getMessage(clazz, 0, id, systemID, lineNumber);
                LOG.warn((Object)msg);
            }
        }
        return chain.getNode(original);
    }

    public void setParameter(String name, String value) {
        if ("reportUnresolvedID".equals(name)) {
            this._reportResolvedID = ObjectUtil.booleanValue(value, true);
        }
        super.setParameter(name, value);
    }

    protected class CheckIDCopyToFilter
    implements CopyToFilter {
        protected CheckIDCopyToFilter() {
        }

        public boolean accept(NodeObject test) {
            if (test instanceof NodeAttribute) {
                NodeAttribute attr = (NodeAttribute)test;
                return !attr.getQName().equals(QM_ID);
            }
            return true;
        }
    }
}

