/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder.injection;

import org.seasar.maya.builder.injection.InjectionChain;
import org.seasar.maya.builder.injection.InjectionResolver;
import org.seasar.maya.engine.specification.NodeAttribute;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.engine.specification.SpecificationNode;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.engine.specification.SpecificationUtil;
import org.seasar.maya.impl.util.StringUtil;

public class MetaValuesSetter
extends ParameterAwareImpl
implements InjectionResolver,
CONST_IMPL {
    protected static final QName QH_CONTENT = SpecificationUtil.createQName("http://www.w3.org/TR/html4", "content");
    protected static final QName QH_HTTP_EQUIV = SpecificationUtil.createQName("http://www.w3.org/TR/html4", "http-equiv");
    protected static final QName QH_META = SpecificationUtil.createQName("http://www.w3.org/TR/html4", "meta");
    protected static final QName QX_CONTENT = SpecificationUtil.createQName("http://www.w3.org/1999/xhtml", "content");
    protected static final QName QX_HTTP_EQUIV = SpecificationUtil.createQName("http://www.w3.org/1999/xhtml", "http-equiv");
    protected static final QName QX_META = SpecificationUtil.createQName("http://www.w3.org/1999/xhtml", "meta");

    protected void addMayaAttribute(SpecificationNode original, QName qName, String value) {
        if (original == null || qName == null || StringUtil.isEmpty(value)) {
            throw new IllegalArgumentException();
        }
        SpecificationNode maya = SpecificationUtil.getMayaNode(original);
        if (maya == null) {
            throw new IllegalStateException();
        }
        maya.addAttribute(qName, value);
    }

    protected void setContentValue(SpecificationNode original, QName httpEquivName, QName contentName) {
        NodeAttribute equiv = original.getAttribute(httpEquivName);
        if (equiv != null) {
            String equivValue = equiv.getValue();
            NodeAttribute content = original.getAttribute(contentName);
            String contentValue = content.getValue();
            if (StringUtil.hasValue(contentValue)) {
                if ("Content-Type".equalsIgnoreCase(equivValue)) {
                    this.addMayaAttribute(original, QM_CONTENT_TYPE, contentValue);
                } else if (("Pragma".equalsIgnoreCase(equivValue) || "Cache-Control".equalsIgnoreCase(equivValue)) && "no-cache".equalsIgnoreCase(contentValue)) {
                    this.addMayaAttribute(original, QM_NO_CACHE, "true");
                }
            }
        }
    }

    public SpecificationNode getNode(SpecificationNode original, InjectionChain chain) {
        if (original == null || chain == null) {
            throw new IllegalArgumentException();
        }
        QName originalName = original.getQName();
        if (QH_META.equals(originalName)) {
            this.setContentValue(original, QH_HTTP_EQUIV, QH_CONTENT);
        } else if (QX_META.equals(originalName)) {
            this.setContentValue(original, QX_HTTP_EQUIV, QX_CONTENT);
        }
        return chain.getNode(original);
    }
}

