/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder.injection;

import org.seasar.maya.builder.injection.InjectionChain;
import org.seasar.maya.builder.injection.InjectionResolver;
import org.seasar.maya.engine.specification.NodeAttribute;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.engine.specification.SpecificationNode;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.builder.BuilderUtil;
import org.seasar.maya.impl.engine.specification.SpecificationUtil;
import org.seasar.maya.impl.util.ObjectUtil;

public class RenderedSetter
extends ParameterAwareImpl
implements InjectionResolver,
CONST_IMPL {
    protected static final QName QM_NULL = SpecificationUtil.createQName("null");
    protected static final QName QM_RENDERED = SpecificationUtil.createQName("rendered");

    protected boolean isRendered(SpecificationNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        NodeAttribute attr = node.getAttribute(QM_RENDERED);
        if (attr != null) {
            return ObjectUtil.booleanValue(attr.getValue(), true);
        }
        return true;
    }

    public SpecificationNode getNode(SpecificationNode original, InjectionChain chain) {
        if (original == null || chain == null) {
            throw new IllegalArgumentException();
        }
        SpecificationNode injected = chain.getNode(original);
        if (injected == null) {
            return null;
        }
        if (!this.isRendered(original) || !this.isRendered(injected)) {
            return BuilderUtil.createInjectedNode(QM_NULL, null, original, false);
        }
        return injected;
    }
}

