/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder.injection;

import java.util.Iterator;
import org.seasar.maya.builder.injection.InjectionChain;
import org.seasar.maya.builder.injection.InjectionResolver;
import org.seasar.maya.engine.specification.CopyToFilter;
import org.seasar.maya.engine.specification.Namespace;
import org.seasar.maya.engine.specification.NodeAttribute;
import org.seasar.maya.engine.specification.NodeObject;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.engine.specification.SpecificationNode;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.engine.specification.SpecificationUtil;
import org.seasar.maya.impl.engine.specification.xpath.XPathUtil;

public class XPathMatchesInjectionResolver
extends ParameterAwareImpl
implements InjectionResolver,
CONST_IMPL {
    protected static final QName QM_XPATH = SpecificationUtil.createQName("xpath");
    private CopyToFilter _xpathFilter = new CheckXPathCopyToFilter();

    protected CopyToFilter getCopyToFilter() {
        return this._xpathFilter;
    }

    public SpecificationNode getNode(SpecificationNode original, InjectionChain chain) {
        if (original == null || chain == null) {
            throw new IllegalArgumentException();
        }
        Namespace namespace = SpecificationUtil.createNamespace();
        namespace.addPrefixMapping("m", "http://maya.seasar.org");
        String xpathExpr = "/m:maya//*[string-length(@m:xpath) > 0]";
        Iterator it = XPathUtil.selectChildNodes(original, xpathExpr, namespace, true);
        while (it.hasNext()) {
            SpecificationNode injected = (SpecificationNode)it.next();
            String mayaPath = SpecificationUtil.getAttributeValue(injected, QM_XPATH);
            if (!XPathUtil.matches(original, mayaPath, injected)) continue;
            return injected.copyTo(this.getCopyToFilter());
        }
        return chain.getNode(original);
    }

    protected class CheckXPathCopyToFilter
    implements CopyToFilter {
        protected CheckXPathCopyToFilter() {
        }

        public boolean accept(NodeObject test) {
            if (test instanceof NodeAttribute) {
                NodeAttribute attr = (NodeAttribute)test;
                return !attr.getQName().equals(QM_XPATH);
            }
            return true;
        }
    }
}

