/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder.library;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.maya.PositionAware;
import org.seasar.maya.builder.library.LibraryDefinition;
import org.seasar.maya.builder.library.LibraryManager;
import org.seasar.maya.builder.library.ProcessorDefinition;
import org.seasar.maya.builder.library.PropertySet;
import org.seasar.maya.builder.library.converter.PropertyConverter;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.provider.ProviderUtil;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.impl.util.collection.NullIterator;

public class LibraryDefinitionImpl
extends ParameterAwareImpl
implements LibraryDefinition {
    private static Log LOG;
    private String _namespaceURI;
    private List _assignedURI = new ArrayList();
    private Map _converters;
    private Map _propertySets;
    private Map _processors;
    private String _systemID;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.maya.impl.builder.library.LibraryDefinitionImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public void setSystemID(String systemID) {
        if (StringUtil.isEmpty(systemID)) {
            throw new IllegalArgumentException();
        }
        this._systemID = systemID;
    }

    public String getSystemID() {
        return this._systemID;
    }

    public void setNamespaceURI(String namespaceURI) {
        if (StringUtil.isEmpty(namespaceURI)) {
            throw new IllegalArgumentException();
        }
        this._namespaceURI = namespaceURI;
    }

    public String getNamespaceURI() {
        return this._namespaceURI;
    }

    public void addAssignedURI(String assignedURI) {
        if (StringUtil.isEmpty(assignedURI)) {
            throw new IllegalArgumentException();
        }
        if (!assignedURI.equals(this._namespaceURI) && !this._assignedURI.contains(assignedURI)) {
            this._assignedURI.add(assignedURI);
        }
    }

    public Iterator iterateAssignedURI() {
        return this._assignedURI.iterator();
    }

    protected void warnAlreadyRegisted(PositionAware obj, String name, int index) {
        if (LOG.isWarnEnabled()) {
            String systemID = obj.getSystemID();
            String lineNumber = Integer.toString(obj.getLineNumber());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.seasar.maya.impl.builder.library.LibraryDefinitionImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LOG.warn((Object)StringUtil.getMessage(clazz, index, name, systemID, lineNumber));
        }
    }

    public void addPropertyConverter(String name, PropertyConverter converter) {
        if (converter == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtil.isEmpty(name)) {
            name = converter.getPropetyClass().getName();
        }
        if (this._converters == null) {
            this._converters = new HashMap();
        }
        if (this._converters.containsKey(name)) {
            this.warnAlreadyRegisted(converter, name, 1);
        } else {
            this._converters.put(name, converter);
        }
    }

    public PropertyConverter getPropertyConverter(Class propertyClass) {
        if (propertyClass == null) {
            throw new IllegalArgumentException();
        }
        if (this._converters != null) {
            Iterator it = this._converters.values().iterator();
            while (it.hasNext()) {
                PropertyConverter converter = (PropertyConverter)it.next();
                if (!propertyClass.equals(converter.getPropetyClass())) continue;
                return converter;
            }
        }
        LibraryManager manager = ProviderUtil.getLibraryManager();
        return manager.getPropertyConverter(propertyClass);
    }

    public PropertyConverter getPropertyConverter(String converterName) {
        if (StringUtil.isEmpty(converterName)) {
            throw new IllegalArgumentException();
        }
        if (this._converters != null && this._converters.containsKey(converterName)) {
            return (PropertyConverter)this._converters.get(converterName);
        }
        LibraryManager manager = ProviderUtil.getLibraryManager();
        return manager.getPropertyConverter(converterName);
    }

    public Iterator iteratePropertyConverters() {
        if (this._converters == null) {
            return NullIterator.getInstance();
        }
        return this._converters.values().iterator();
    }

    public void addPropertySet(PropertySet propertySet) {
        if (propertySet == null) {
            throw new IllegalArgumentException();
        }
        String name = propertySet.getName();
        if (this._propertySets == null) {
            this._propertySets = new HashMap();
        }
        if (this._propertySets.containsKey(name)) {
            this.warnAlreadyRegisted(propertySet, name, 2);
        } else {
            this._propertySets.put(name, propertySet);
        }
    }

    public Iterator iteratePropertySets() {
        if (this._propertySets == null) {
            return NullIterator.getInstance();
        }
        return this._propertySets.values().iterator();
    }

    public PropertySet getPropertySet(String name) {
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        if (this._propertySets == null) {
            return null;
        }
        return (PropertySet)this._propertySets.get(name);
    }

    public void addProcessorDefinition(ProcessorDefinition processor) {
        if (processor == null) {
            throw new IllegalArgumentException();
        }
        String name = processor.getName();
        if (this._processors == null) {
            this._processors = new HashMap();
        }
        if (this._processors.containsKey(name)) {
            this.warnAlreadyRegisted(processor, name, 3);
        } else {
            this._processors.put(name, processor);
        }
    }

    public Iterator iterateProcessorDefinitions() {
        if (this._processors == null) {
            return NullIterator.getInstance();
        }
        return this._processors.values().iterator();
    }

    public ProcessorDefinition getProcessorDefinition(String name) {
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        if (this._processors == null) {
            return null;
        }
        return (ProcessorDefinition)this._processors.get(name);
    }
}

