/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder.library;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.maya.builder.library.DefinitionBuilder;
import org.seasar.maya.builder.library.LibraryDefinition;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.builder.library.scanner.SourceAlias;
import org.seasar.maya.impl.builder.library.scanner.WebXMLTaglibSourceScanner;
import org.seasar.maya.impl.builder.library.tld.TLDLibraryDefinitionHandler;
import org.seasar.maya.impl.util.IOUtil;
import org.seasar.maya.impl.util.ObjectUtil;
import org.seasar.maya.impl.util.XMLUtil;
import org.seasar.maya.source.SourceDescriptor;

public class TLDDefinitionBuilder
extends ParameterAwareImpl
implements DefinitionBuilder {
    private static Log LOG;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.maya.impl.builder.library.TLDDefinitionBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LibraryDefinition build(SourceDescriptor source) {
        block8: {
            if (source == null) {
                throw new IllegalArgumentException();
            }
            String systemID = source.getSystemID();
            if (!source.exists() || !systemID.toLowerCase().endsWith(".tld")) break block8;
            InputStream stream = source.getInputStream();
            TLDLibraryDefinitionHandler handler = new TLDLibraryDefinitionHandler();
            try {
                try {
                    XMLUtil.parse(handler, stream, "tld", systemID, true, true, true);
                }
                catch (Throwable t) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("TLD parse error on " + systemID), t);
                    }
                    LibraryDefinition libraryDefinition = null;
                    Object var6_8 = null;
                    IOUtil.close(stream);
                    return libraryDefinition;
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                IOUtil.close(stream);
                throw throwable;
            }
            {
                Object var6_10 = null;
            }
            IOUtil.close(stream);
            LibraryDefinition library = handler.getLibraryDefinition();
            boolean assigned = ObjectUtil.booleanValue(source.getParameter(WebXMLTaglibSourceScanner.ASSIGNED), false);
            if (assigned || "/META-INF/taglib.tld".equals(systemID)) {
                library.addAssignedURI(source.getParameter(SourceAlias.ALIAS));
            }
            return library;
        }
        return null;
    }
}

