/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder.library.scanner;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.seasar.maya.builder.library.scanner.SourceScanner;
import org.seasar.maya.impl.IllegalParameterValueException;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.builder.library.scanner.FolderSourceScanner;
import org.seasar.maya.impl.builder.library.scanner.SourceAlias;
import org.seasar.maya.impl.source.ClassLoaderSourceDescriptor;
import org.seasar.maya.impl.util.IOUtil;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.source.SourceDescriptor;

public class MetaInfSourceScanner
extends ParameterAwareImpl
implements SourceScanner {
    private static Map _cache = new HashMap();
    private FolderSourceScanner _folderScanner = new FolderSourceScanner();
    private Set _ignores = new HashSet();

    protected String getJarName(String systemID) {
        if (StringUtil.hasValue(systemID)) {
            int pos = systemID.lastIndexOf("/");
            if (pos != -1) {
                return systemID.substring(pos + 1);
            }
            return systemID;
        }
        return null;
    }

    protected boolean containIgnores(String name) {
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        Iterator it = this._ignores.iterator();
        while (it.hasNext()) {
            if (!name.startsWith(it.next().toString())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void scanSource(SourceDescriptor source, Set aliases) {
        if (source == null && !source.exists()) {
            throw new IllegalArgumentException();
        }
        String jarName = this.getJarName(source.getSystemID());
        if (!StringUtil.hasValue(jarName)) return;
        if (this.containIgnores(jarName)) return;
        InputStream stream = source.getInputStream();
        try {
            try {
                JarEntry entry;
                JarInputStream jar = new JarInputStream(stream);
                while ((entry = jar.getNextJarEntry()) != null) {
                    String entryName = entry.getName();
                    if (!entryName.startsWith("META-INF/") || "META-INF/MANIFEST.MF".equals(entryName)) continue;
                    aliases.add(new SourceAlias(jarName, entryName, source.getTimestamp()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            IOUtil.close(stream);
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        IOUtil.close(stream);
    }

    protected Set scanAll(SourceScanner scanner) {
        if (scanner == null) {
            throw new IllegalArgumentException();
        }
        HashSet aliases = new HashSet();
        Iterator it = scanner.scan();
        while (it.hasNext()) {
            SourceDescriptor source = (SourceDescriptor)it.next();
            this.scanSource(source, aliases);
        }
        return aliases;
    }

    public Iterator scan() {
        String folder = this._folderScanner.getFolder();
        Set aliases = (Set)_cache.get(folder);
        if (aliases == null) {
            aliases = this.scanAll(this._folderScanner);
            _cache.put(folder, aliases);
        }
        return new MetaInfSourceIterator(aliases.iterator());
    }

    public void setParameter(String name, String value) {
        if ("ignore".equals(name)) {
            if (StringUtil.isEmpty(value)) {
                throw new IllegalParameterValueException(this.getClass(), name);
            }
            this._ignores.add(value);
        } else {
            this._folderScanner.setParameter(name, value);
        }
        super.setParameter(name, value);
    }

    protected class MetaInfSourceIterator
    implements Iterator {
        private Iterator _it;

        public MetaInfSourceIterator(Iterator it) {
            if (it == null) {
                throw new IllegalArgumentException();
            }
            this._it = it;
        }

        public boolean hasNext() {
            return this._it.hasNext();
        }

        public Object next() {
            SourceAlias alias = (SourceAlias)this._it.next();
            ClassLoaderSourceDescriptor source = new ClassLoaderSourceDescriptor();
            source.setSystemID(alias.getSystemID());
            source.setParameter(SourceAlias.ALIAS, alias.getAlias());
            source.setTimestamp(alias.getTimestamp());
            return source;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

