/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder.library.scanner;

import java.io.InputStream;
import java.util.Iterator;
import org.seasar.maya.builder.library.scanner.SourceScanner;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.builder.library.scanner.SourceAlias;
import org.seasar.maya.impl.builder.library.scanner.TaglibLocationsHandler;
import org.seasar.maya.impl.source.ApplicationSourceDescriptor;
import org.seasar.maya.impl.util.IOUtil;
import org.seasar.maya.impl.util.XMLUtil;
import org.seasar.maya.source.SourceDescriptor;

public class WebXMLTaglibSourceScanner
extends ParameterAwareImpl
implements SourceScanner {
    public static final String ASSIGNED;
    static /* synthetic */ Class class$0;

    static {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.maya.impl.builder.library.scanner.WebXMLTaglibSourceScanner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ASSIGNED = stringBuffer.append(clazz).append(".ASSIGNED").toString();
    }

    protected Iterator scanWebXml(SourceDescriptor source) {
        Iterator iterator;
        if (source == null) {
            throw new IllegalArgumentException();
        }
        if (!source.exists()) {
            throw new IllegalStateException();
        }
        InputStream stream = source.getInputStream();
        try {
            TaglibLocationsHandler handler = new TaglibLocationsHandler();
            XMLUtil.parse(handler, stream, "web.xml", source.getSystemID(), true, true, true);
            iterator = handler.iterateTaglibLocations();
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            IOUtil.close(stream);
            throw throwable;
        }
        IOUtil.close(stream);
        return iterator;
    }

    public Iterator scan() {
        ApplicationSourceDescriptor source = new ApplicationSourceDescriptor();
        source.setRoot("/WEB-INF");
        source.setSystemID("web.xml");
        return new TaglibLocationIterator(this.scanWebXml(source));
    }

    private class TaglibLocationIterator
    implements Iterator {
        private Iterator _it;

        TaglibLocationIterator(Iterator it) {
            if (it == null) {
                throw new IllegalArgumentException();
            }
            this._it = it;
        }

        public boolean hasNext() {
            return this._it.hasNext();
        }

        public Object next() {
            SourceAlias alias = (SourceAlias)this._it.next();
            String systemID = alias.getSystemID();
            if (systemID.startsWith("/WEB-INF/")) {
                systemID = systemID.substring(9);
            }
            ApplicationSourceDescriptor source = new ApplicationSourceDescriptor();
            if (!systemID.startsWith("/")) {
                source.setRoot("/WEB-INF");
            }
            source.setSystemID(systemID);
            source.setParameter(SourceAlias.ALIAS, alias.getAlias());
            source.setParameter(ASSIGNED, "true");
            return source;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

