/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.cycle;

import java.util.Iterator;
import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.cycle.scope.AttributeScope;
import org.seasar.maya.cycle.script.CompiledScript;
import org.seasar.maya.cycle.script.ScriptEnvironment;
import org.seasar.maya.engine.processor.ProcessorTreeWalker;
import org.seasar.maya.engine.specification.NodeTreeWalker;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.cycle.CycleUtil;
import org.seasar.maya.impl.cycle.ScopeIterator;
import org.seasar.maya.impl.cycle.ScriptFileNotFoundException;
import org.seasar.maya.impl.cycle.scope.ScopeNotFoundException;
import org.seasar.maya.impl.provider.ProviderUtil;
import org.seasar.maya.impl.source.ApplicationSourceDescriptor;
import org.seasar.maya.impl.source.SourceUtil;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.source.SourceDescriptor;

public abstract class AbstractServiceCycle
extends ParameterAwareImpl
implements ServiceCycle {
    private Object _context;
    private AttributeScope _page;
    private NodeTreeWalker _originalNode;
    private NodeTreeWalker _injectedNode;
    private ProcessorTreeWalker _processor;
    private Throwable _t;

    public void load(String systemID) {
        this.load(systemID, "UTF-8");
    }

    public void load(String systemID, String encoding) {
        if (StringUtil.isEmpty(systemID)) {
            throw new ScriptFileNotFoundException("");
        }
        String sid = systemID;
        if (sid.startsWith("/WEB-INF/")) {
            sid = sid.substring(9);
        }
        ApplicationSourceDescriptor appSource = new ApplicationSourceDescriptor();
        if (!sid.startsWith("/")) {
            appSource.setRoot("/WEB-INF");
        }
        appSource.setSystemID(sid);
        SourceDescriptor source = null;
        if (appSource.exists()) {
            source = appSource;
        } else {
            source = SourceUtil.getSourceDescriptor(sid);
            if (!source.exists()) {
                source = null;
            }
        }
        if (source == null) {
            throw new ScriptFileNotFoundException(systemID);
        }
        ScriptEnvironment env = ProviderUtil.getScriptEnvironment();
        CompiledScript script = env.compile(source, encoding);
        script.execute(null);
    }

    public Iterator iterateAttributeScope() {
        Iterator it = ProviderUtil.getScriptEnvironment().iterateAttributeScope();
        return new ScopeIterator(this, it);
    }

    public boolean hasAttributeScope(String scopeName) {
        if (StringUtil.isEmpty(scopeName)) {
            scopeName = "page";
        }
        Iterator it = CycleUtil.getServiceCycle().iterateAttributeScope();
        while (it.hasNext()) {
            AttributeScope scope = (AttributeScope)it.next();
            if (!scope.getScopeName().equals(scopeName)) continue;
            return true;
        }
        return false;
    }

    public AttributeScope getAttributeScope(String scopeName) {
        if (StringUtil.isEmpty(scopeName)) {
            scopeName = "page";
        }
        Iterator it = CycleUtil.getServiceCycle().iterateAttributeScope();
        while (it.hasNext()) {
            AttributeScope scope = (AttributeScope)it.next();
            if (!scope.getScopeName().equals(scopeName)) continue;
            return scope;
        }
        throw new ScopeNotFoundException(scopeName);
    }

    public void setPageScope(AttributeScope page) {
        this._page = page;
    }

    public AttributeScope getPageScope() {
        return this._page;
    }

    public void setOriginalNode(NodeTreeWalker originalNode) {
        this._originalNode = originalNode;
    }

    public NodeTreeWalker getOriginalNode() {
        return this._originalNode;
    }

    public void setInjectedNode(NodeTreeWalker injectedNode) {
        this._injectedNode = injectedNode;
    }

    public NodeTreeWalker getInjectedNode() {
        return this._injectedNode;
    }

    public void setProcessor(ProcessorTreeWalker processor) {
        this._processor = processor;
    }

    public ProcessorTreeWalker getProcessor() {
        return this._processor;
    }

    public void setHandledError(Throwable t) {
        this._t = t;
    }

    public Throwable getHandledError() {
        return this._t;
    }

    public void setUnderlyingContext(Object context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this._context = context;
    }

    public Object getUnderlyingContext() {
        if (this._context == null) {
            throw new IllegalStateException();
        }
        return this._context;
    }
}

