/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.cycle;

import java.util.Iterator;
import org.seasar.maya.cycle.CycleFactory;
import org.seasar.maya.cycle.Response;
import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.cycle.scope.RequestScope;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.cycle.CycleNotInitializedException;
import org.seasar.maya.impl.util.ObjectUtil;

public class CycleFactoryImpl
extends ParameterAwareImpl
implements CycleFactory {
    private static final long serialVersionUID = 6930908159752133949L;
    private Object _context;
    private Class _serviceClass;
    private ThreadLocal _currentCycle = new ThreadLocal();

    public void setServiceClass(Class serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException();
        }
        this._serviceClass = serviceClass;
    }

    public Class getServiceClass() {
        if (this._serviceClass == null) {
            throw new IllegalArgumentException();
        }
        return this._serviceClass;
    }

    public void initialize(Object requestContext, Object responseContext) {
        if (requestContext == null || responseContext == null) {
            throw new IllegalArgumentException();
        }
        Class serviceCycleClass = this.getServiceClass();
        if (serviceCycleClass == null) {
            throw new IllegalStateException();
        }
        ServiceCycle cycle = (ServiceCycle)ObjectUtil.newInstance(serviceCycleClass);
        cycle.setUnderlyingContext(this.getUnderlyingContext());
        Iterator it = this.iterateParameterNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = this.getParameter(key);
            cycle.setParameter(key, value);
        }
        this._currentCycle.set(cycle);
        RequestScope request = cycle.getRequestScope();
        request.setUnderlyingContext(requestContext);
        Response response = cycle.getResponse();
        response.setUnderlyingContext(responseContext);
    }

    public ServiceCycle getServiceCycle() {
        ServiceCycle cycle = (ServiceCycle)this._currentCycle.get();
        if (cycle == null) {
            throw new CycleNotInitializedException();
        }
        return cycle;
    }

    public void setUnderlyingContext(Object context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this._context = context;
    }

    public Object getUnderlyingContext() {
        if (this._context == null) {
            throw new IllegalStateException();
        }
        return this._context;
    }
}

