/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.cycle;

import org.seasar.maya.FactoryFactory;
import org.seasar.maya.cycle.CycleFactory;
import org.seasar.maya.cycle.Response;
import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.cycle.scope.AttributeScope;
import org.seasar.maya.cycle.scope.RequestScope;
import org.seasar.maya.impl.cycle.scope.ScopeNotWritableException;
import org.seasar.maya.impl.util.StringUtil;

public class CycleUtil {
    public static final String[] STANDARD_SCOPES = new String[]{"page", "request", "session", "application"};
    static /* synthetic */ Class class$0;

    private CycleUtil() {
    }

    public static void initialize(Object requestContext, Object responseContext) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.maya.cycle.CycleFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CycleFactory factory = (CycleFactory)FactoryFactory.getFactory(clazz);
        factory.initialize(requestContext, responseContext);
    }

    public static ServiceCycle getServiceCycle() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.maya.cycle.CycleFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CycleFactory factory = (CycleFactory)FactoryFactory.getFactory(clazz);
        return factory.getServiceCycle();
    }

    public static RequestScope getRequestScope() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        return cycle.getRequestScope();
    }

    public static Response getResponse() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        return cycle.getResponse();
    }

    public static AttributeScope findStandardAttributeScope(String name) {
        if (StringUtil.isEmpty(name)) {
            return null;
        }
        int i = 0;
        while (i < STANDARD_SCOPES.length) {
            ServiceCycle cycle = CycleUtil.getServiceCycle();
            AttributeScope scope = cycle.getAttributeScope(STANDARD_SCOPES[i]);
            if (scope.hasAttribute(name)) {
                return scope;
            }
            ++i;
        }
        return null;
    }

    public static Object getAttribute(String name, String scopeName) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        AttributeScope scope = cycle.getAttributeScope(scopeName);
        return scope.getAttribute(name);
    }

    public static void setAttribute(String name, Object value, String scopeName) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        AttributeScope scope = cycle.getAttributeScope(scopeName);
        if (!scope.isAttributeWritable()) {
            throw new ScopeNotWritableException(scopeName);
        }
        scope.setAttribute(name, value);
    }

    public static void removeAttribute(String name, String scopeName) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        AttributeScope scope = cycle.getAttributeScope(scopeName);
        if (!scope.isAttributeWritable()) {
            throw new ScopeNotWritableException(scopeName);
        }
        scope.removeAttribute(name);
    }
}

