/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.cycle.jsp;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.BodyContent;
import org.seasar.maya.cycle.Response;
import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.cycle.scope.ApplicationScope;
import org.seasar.maya.cycle.scope.AttributeScope;
import org.seasar.maya.cycle.scope.RequestScope;
import org.seasar.maya.cycle.scope.SessionScope;
import org.seasar.maya.impl.cycle.CycleUtil;
import org.seasar.maya.impl.cycle.jsp.BodyContentImpl;
import org.seasar.maya.impl.cycle.jsp.ExpressionEvaluatorImpl;
import org.seasar.maya.impl.cycle.jsp.JspWriterImpl;
import org.seasar.maya.impl.cycle.jsp.VariableResolverImpl;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.impl.util.collection.IteratorEnumeration;

public class PageContextImpl
extends PageContext {
    private static final int[] JSP_SCOPES = new int[]{1, 2, 3, 4};
    private ServletConfig _config;

    private String getScopeFromInt(int scope) {
        if (scope == 4) {
            return "application";
        }
        if (scope == 3) {
            return "session";
        }
        if (scope == 2) {
            return "request";
        }
        if (scope == 1) {
            return "page";
        }
        throw new IllegalArgumentException();
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) {
        throw new IllegalStateException();
    }

    public void release() {
        throw new IllegalStateException();
    }

    public JspWriter getOut() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        Response response = cycle.getResponse();
        return new JspWriterImpl(response.getWriter());
    }

    public JspWriter popBody() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        Response response = cycle.getResponse();
        return new JspWriterImpl(response.getWriter());
    }

    public BodyContent pushBody() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        Response response = cycle.getResponse();
        return new BodyContentImpl(response.pushWriter());
    }

    public void forward(String relativeUrlPath) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.forward(relativeUrlPath);
    }

    public void include(String relativeUrlPath) throws ServletException, IOException {
        this.include(relativeUrlPath, false);
    }

    protected String getContextRelativePath(ServletRequest request, String relativePath) {
        if (relativePath.startsWith("/") || !(request instanceof HttpServletRequest)) {
            return relativePath;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String uri = httpRequest.getServletPath();
        if (StringUtil.hasValue(uri)) {
            int pos = uri.lastIndexOf(47);
            if (pos >= 0) {
                uri = uri.substring(0, pos);
            }
        } else {
            uri = "";
        }
        return String.valueOf(uri) + '/' + relativePath;
    }

    public void include(String relativeUrlPath, boolean flush) throws ServletException, IOException {
        if (flush) {
            Response response = CycleUtil.getResponse();
            response.getWriter().flush();
        }
        ServletRequest request = this.getRequest();
        String contextRelativePath = this.getContextRelativePath(request, relativeUrlPath);
        RequestDispatcher dispatcher = request.getRequestDispatcher(contextRelativePath);
        dispatcher.include(request, this.getResponse());
    }

    public void handlePageException(Exception e) {
        this.handlePageException((Throwable)e);
    }

    public void handlePageException(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    public Exception getException() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        Throwable t = cycle.getHandledError();
        if (t instanceof Exception) {
            return (Exception)t;
        }
        return null;
    }

    public ServletContext getServletContext() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        ApplicationScope application = cycle.getApplicationScope();
        Object obj = application.getUnderlyingContext();
        if (obj instanceof ServletContext) {
            return (ServletContext)obj;
        }
        throw new IllegalStateException();
    }

    public HttpSession getSession() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        SessionScope session = cycle.getSessionScope();
        Object obj = session.getUnderlyingContext();
        if (obj instanceof HttpSession) {
            return (HttpSession)obj;
        }
        throw new IllegalStateException();
    }

    public ServletRequest getRequest() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        RequestScope request = cycle.getRequestScope();
        Object obj = request.getUnderlyingContext();
        if (obj instanceof ServletRequest) {
            return (ServletRequest)obj;
        }
        throw new IllegalStateException();
    }

    public ServletResponse getResponse() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        Response response = cycle.getResponse();
        Object obj = response.getUnderlyingContext();
        if (obj instanceof ServletResponse) {
            return (ServletResponse)obj;
        }
        throw new IllegalStateException();
    }

    public ServletConfig getServletConfig() {
        if (this._config == null) {
            this._config = new CycleServletConfig();
        }
        return this._config;
    }

    public Object getPage() {
        throw new UnsupportedOperationException();
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        return ExpressionEvaluatorImpl.getInstance();
    }

    public VariableResolver getVariableResolver() {
        return VariableResolverImpl.getInstance();
    }

    public Object findAttribute(String name) {
        int i = 0;
        while (i < CycleUtil.STANDARD_SCOPES.length) {
            Object ret = CycleUtil.getAttribute(name, CycleUtil.STANDARD_SCOPES[i]);
            if (ret != null) {
                return ret;
            }
            ++i;
        }
        return null;
    }

    public Object getAttribute(String name, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        String scopeName = this.getScopeFromInt(scope);
        return CycleUtil.getAttribute(name, scopeName);
    }

    public Object getAttribute(String name) {
        return this.getAttribute(name, 1);
    }

    public void removeAttribute(String name, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        String scopeName = this.getScopeFromInt(scope);
        CycleUtil.removeAttribute(name, scopeName);
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < CycleUtil.STANDARD_SCOPES.length) {
            CycleUtil.removeAttribute(name, CycleUtil.STANDARD_SCOPES[i]);
            ++i;
        }
    }

    public void setAttribute(String name, Object value, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        String scopeName = this.getScopeFromInt(scope);
        CycleUtil.setAttribute(name, value, scopeName);
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value, 1);
    }

    public Enumeration getAttributeNamesInScope(int scope) {
        String scopeName = this.getScopeFromInt(scope);
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        AttributeScope attrScope = cycle.getAttributeScope(scopeName);
        return IteratorEnumeration.getInstance(attrScope.iterateAttributeNames());
    }

    public int getAttributesScope(String name) {
        int i = 0;
        while (i < CycleUtil.STANDARD_SCOPES.length) {
            Object ret = CycleUtil.getAttribute(name, CycleUtil.STANDARD_SCOPES[i]);
            if (ret != null) {
                return JSP_SCOPES[i];
            }
            ++i;
        }
        return 0;
    }

    private class CycleServletConfig
    implements ServletConfig {
        CycleServletConfig() {
        }

        public String getInitParameter(String name) {
            return this.getServletContext().getInitParameter(name);
        }

        public Enumeration getInitParameterNames() {
            return this.getServletContext().getInitParameterNames();
        }

        public ServletContext getServletContext() {
            return this.getServletContext();
        }

        public String getServletName() {
            return "Maya Servlet";
        }
    }
}

