/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.cycle.scope;

import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.cycle.scope.ApplicationScope;
import org.seasar.maya.cycle.scope.RequestScope;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.cycle.CycleUtil;
import org.seasar.maya.impl.cycle.scope.AbstractWritableAttributeScope;
import org.seasar.maya.impl.engine.EngineUtil;
import org.seasar.maya.impl.util.StringUtil;

public abstract class AbstractRequestScope
extends AbstractWritableAttributeScope
implements RequestScope,
CONST_IMPL {
    private String _pageName;
    private String _requestedSuffix;
    private String _extension;
    private String _mimeType;

    public void parsePath(String path) {
        String suffixSeparator = EngineUtil.getEngineSetting("suffixSeparator", "$");
        String[] parsed = StringUtil.parsePath(path, suffixSeparator);
        this._pageName = parsed[0];
        this._requestedSuffix = parsed[1];
        this._extension = parsed[2];
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        ApplicationScope application = cycle.getApplicationScope();
        this._mimeType = application.getMimeType(path);
    }

    public void setForwardPath(String relativeUrlPath) {
        if (StringUtil.isEmpty(relativeUrlPath)) {
            throw new IllegalArgumentException();
        }
        this.parsePath(relativeUrlPath);
    }

    public String getScopeName() {
        return "request";
    }

    public String getPageName() {
        if (this._pageName == null) {
            this.parsePath(this.getRequestedPath());
        }
        return this._pageName;
    }

    public String getRequestedSuffix() {
        if (this._requestedSuffix == null) {
            this.parsePath(this.getRequestedPath());
        }
        return this._requestedSuffix;
    }

    public String getExtension() {
        if (this._extension == null) {
            this.parsePath(this.getRequestedPath());
        }
        return this._extension;
    }

    public String getMimeType() {
        if (this._mimeType == null) {
            this.parsePath(this.getRequestedPath());
        }
        return this._mimeType;
    }
}

