/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.cycle.script;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.seasar.maya.PositionAware;
import org.seasar.maya.cycle.scope.AttributeScope;
import org.seasar.maya.cycle.script.CompiledScript;
import org.seasar.maya.cycle.script.ScriptEnvironment;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.cycle.script.ComplexScript;
import org.seasar.maya.impl.cycle.script.LiteralScript;
import org.seasar.maya.impl.cycle.script.ScriptBlock;
import org.seasar.maya.impl.cycle.script.ScriptBlockIterator;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.impl.util.collection.NullIterator;

public abstract class AbstractScriptEnvironment
extends ParameterAwareImpl
implements ScriptEnvironment {
    private List _attributeScopes;
    private String _blockSign = "$";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttributeScope(AttributeScope attrs) {
        if (attrs == null) {
            throw new IllegalArgumentException();
        }
        if (this._attributeScopes == null) {
            this._attributeScopes = new ArrayList();
        }
        List list = this._attributeScopes;
        synchronized (list) {
            this._attributeScopes.add(attrs);
        }
    }

    public Iterator iterateAttributeScope() {
        if (this._attributeScopes == null) {
            return NullIterator.getInstance();
        }
        return this._attributeScopes.iterator();
    }

    public void setBlockSign(String blockSign) {
        if (StringUtil.isEmpty(blockSign)) {
            throw new IllegalArgumentException();
        }
        this._blockSign = blockSign;
    }

    public String getBlockSign() {
        return this._blockSign;
    }

    protected abstract CompiledScript compile(ScriptBlock var1, PositionAware var2);

    public CompiledScript compile(String script, PositionAware position) {
        if (StringUtil.isEmpty(script)) {
            return new LiteralScript("");
        }
        ArrayList<CompiledScript> list = new ArrayList<CompiledScript>();
        ScriptBlockIterator it = new ScriptBlockIterator(script, this._blockSign, position.isOnTemplate());
        while (it.hasNext()) {
            ScriptBlock block = (ScriptBlock)it.next();
            list.add(this.compile(block, position));
        }
        if (list.size() == 1) {
            return (CompiledScript)list.get(0);
        }
        CompiledScript[] compiled = list.toArray(new CompiledScript[list.size()]);
        return new ComplexScript(compiled);
    }
}

