/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.cycle.script;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.seasar.maya.impl.cycle.script.ScriptBlock;
import org.seasar.maya.impl.cycle.script.UnbalancedBraceException;
import org.seasar.maya.impl.util.StringUtil;

public class ScriptBlockIterator
implements Iterator {
    private String _text;
    private String _blockSign;
    private int _offset;
    private boolean _onTemplate = true;

    public ScriptBlockIterator(String text, String blockSign, boolean onTemplate) {
        if (StringUtil.isEmpty(text) || StringUtil.isEmpty(blockSign)) {
            throw new IllegalArgumentException();
        }
        this._text = text;
        this._blockSign = blockSign;
        this._offset = 0;
        this._onTemplate = onTemplate;
    }

    public boolean hasNext() {
        return this._offset < this._text.length();
    }

    protected int scanBlockCloseOffset(int start) {
        char c = this._text.charAt(start);
        if (c != '{') {
            throw new IllegalArgumentException();
        }
        int depth = 0;
        int i = start;
        while (i < this._text.length()) {
            c = this._text.charAt(i);
            if (c == '{') {
                ++depth;
            } else if (c == '}') {
                if (--depth == 0) {
                    return i;
                }
                if (depth < 0) {
                    throw new UnbalancedBraceException(this._text, i);
                }
            }
            ++i;
        }
        return -1;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String blockStart = String.valueOf(this._blockSign) + "{";
        int sign = this._text.indexOf(blockStart, this._offset);
        if (sign != -1) {
            if (this._offset == sign) {
                int close = this.scanBlockCloseOffset(this._offset + this._blockSign.length());
                if (close == -1) {
                    throw new UnbalancedBraceException(this._text, this._text.length());
                }
                String text = this._text.substring(this._offset + blockStart.length(), close);
                this._offset = close + 1;
                if (this._onTemplate) {
                    text = StringUtil.resolveEntity(text);
                }
                return new ScriptBlock(text, false, this._blockSign);
            }
            String lastLiteralBlock = this._text.substring(this._offset, sign);
            this._offset = sign;
            return new ScriptBlock(lastLiteralBlock, true, this._blockSign);
        }
        String lastLiteralBlock = this._text.substring(this._offset);
        this._offset = this._text.length();
        return new ScriptBlock(lastLiteralBlock, true, this._blockSign);
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

