/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.cycle.web;

import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.maya.cycle.scope.SessionScope;
import org.seasar.maya.cycle.script.ScriptEnvironment;
import org.seasar.maya.impl.cycle.scope.AbstractWritableAttributeScope;
import org.seasar.maya.impl.provider.ProviderUtil;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.impl.util.collection.EnumerationIterator;

public class SessionScopeImpl
extends AbstractWritableAttributeScope
implements SessionScope {
    private static final long serialVersionUID = -3211729351966533995L;
    private HttpServletRequest _httpRequest;
    private HttpSession _httpSession;

    protected void check() {
        if (this._httpRequest == null) {
            throw new IllegalStateException();
        }
        if (this._httpSession == null) {
            this._httpSession = this._httpRequest.getSession(true);
        }
    }

    public String getSessionID() {
        this.check();
        return this._httpSession.getId();
    }

    public String getScopeName() {
        return "session";
    }

    public Iterator iterateAttributeNames() {
        this.check();
        return EnumerationIterator.getInstance(this._httpSession.getAttributeNames());
    }

    public boolean hasAttribute(String name) {
        if (StringUtil.isEmpty(name)) {
            return false;
        }
        this.check();
        Enumeration e = this._httpSession.getAttributeNames();
        while (e.hasMoreElements()) {
            if (!e.nextElement().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Object getAttribute(String name) {
        if (StringUtil.isEmpty(name)) {
            return null;
        }
        this.check();
        ScriptEnvironment env = ProviderUtil.getScriptEnvironment();
        return env.convertFromScriptObject(this._httpSession.getAttribute(name));
    }

    public void setAttribute(String name, Object attribute) {
        if (StringUtil.isEmpty(name)) {
            return;
        }
        this.check();
        this._httpSession.setAttribute(name, attribute);
    }

    public void removeAttribute(String name) {
        if (StringUtil.isEmpty(name)) {
            return;
        }
        this.check();
        this._httpSession.removeAttribute(name);
    }

    public void setUnderlyingContext(Object context) {
        if (context == null || !(context instanceof HttpServletRequest)) {
            throw new IllegalArgumentException();
        }
        this._httpRequest = (HttpServletRequest)context;
        this._httpSession = null;
    }

    public Object getUnderlyingContext() {
        this.check();
        return this._httpSession;
    }
}

