/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.seasar.maya.builder.TemplateBuilder;
import org.seasar.maya.cycle.Response;
import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.cycle.scope.RequestScope;
import org.seasar.maya.engine.Page;
import org.seasar.maya.engine.Template;
import org.seasar.maya.engine.processor.ProcessStatus;
import org.seasar.maya.engine.processor.ProcessorTreeWalker;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.engine.specification.Specification;
import org.seasar.maya.engine.specification.SpecificationNode;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.cycle.CycleUtil;
import org.seasar.maya.impl.engine.EngineUtil;
import org.seasar.maya.impl.engine.RenderUtil;
import org.seasar.maya.impl.engine.specification.SpecificationImpl;
import org.seasar.maya.impl.engine.specification.SpecificationUtil;
import org.seasar.maya.impl.provider.ProviderUtil;
import org.seasar.maya.impl.util.ObjectUtil;
import org.seasar.maya.impl.util.StringUtil;

public class TemplateImpl
extends SpecificationImpl
implements Template,
CONST_IMPL {
    private static final long serialVersionUID = -5368325487192629078L;
    private Page _page;
    private String _suffix;
    private String _extension;
    private List _childProcessors = new ArrayList();

    public TemplateImpl(Page page, String suffix, String extension) {
        if (page == null || suffix == null || extension == null) {
            throw new IllegalArgumentException();
        }
        this._page = page;
        this._suffix = suffix;
        this._extension = extension;
    }

    public Page getPage() {
        return this._page;
    }

    public String getSuffix() {
        return this._suffix;
    }

    public String getExtension() {
        return this._extension;
    }

    protected String getMayaAttribute(Specification spec, QName qname) {
        SpecificationNode maya = SpecificationUtil.getMayaNode(spec);
        if (maya != null) {
            return SpecificationUtil.getAttributeValue(maya, qname);
        }
        return null;
    }

    protected String findMayaAttribute(Page topLevelPage, QName qname) {
        String topLevelValue = this.getMayaAttribute(topLevelPage, qname);
        if (StringUtil.hasValue(topLevelValue)) {
            return topLevelValue;
        }
        Specification spec = this;
        while (spec != null) {
            String value = this.getMayaAttribute(spec, qname);
            if (StringUtil.hasValue(value)) {
                return value;
            }
            spec = EngineUtil.getParentSpecification(spec);
        }
        return null;
    }

    protected String getContentType(Page topLevelPage) {
        String contentType = this.findMayaAttribute(topLevelPage, QM_CONTENT_TYPE);
        if (contentType != null) {
            return contentType;
        }
        RequestScope request = CycleUtil.getRequestScope();
        String ret = request.getMimeType();
        if (ret == null) {
            ret = "text/html; charset=UTF-8";
        }
        return ret;
    }

    protected boolean isNoCache(Page topLevelPage) {
        String noCache = this.findMayaAttribute(topLevelPage, QM_NO_CACHE);
        if (noCache != null) {
            return ObjectUtil.booleanValue(noCache, false);
        }
        return false;
    }

    protected void prepareCycle(Page topLevelPage) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        Response response = cycle.getResponse();
        String contentType = this.getContentType(topLevelPage);
        response.setContentType(contentType);
        if (this.isNoCache(topLevelPage)) {
            response.addHeader("Pragma", "no-cache");
            response.addHeader("Cache-Control", "no-cache");
            response.addHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        }
    }

    public ProcessStatus doTemplateRender(Page topLevelPage) {
        RenderUtil.saveToCycle(this);
        this.prepareCycle(topLevelPage);
        ProcessStatus ret = RenderUtil.renderProcessorTree(topLevelPage, this);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        TemplateImpl templateImpl = this;
        synchronized (templateImpl) {
            this._childProcessors.clear();
            super.clear();
        }
    }

    protected void parseSpecification() {
        this.setTimestamp(new Date());
        this.clear();
        TemplateBuilder builder = ProviderUtil.getTemplateBuilder();
        builder.build(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimestamps() {
        Date templateTime = this.getTimestamp();
        if (templateTime != null) {
            Page page = this.getPage();
            Date pageTime = page.getTimestamp();
            Date engineTime = ProviderUtil.getEngine().getTimestamp();
            if (pageTime.after(templateTime) || engineTime.after(templateTime)) {
                this.setTimestamp(null);
            }
        }
        TemplateImpl templateImpl = this;
        synchronized (templateImpl) {
            if (this.isSourceNotExists() || this.isOldSpecification()) {
                this.parseSpecification();
            }
        }
    }

    public Map getVariables() {
        return null;
    }

    public void setParentProcessor(ProcessorTreeWalker parent, int index) {
        throw new IllegalStateException();
    }

    public ProcessorTreeWalker getParentProcessor() {
        return null;
    }

    public int getIndex() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildProcessor(ProcessorTreeWalker child) {
        if (child == null) {
            throw new IllegalArgumentException();
        }
        List list = this._childProcessors;
        synchronized (list) {
            this._childProcessors.add(child);
            child.setParentProcessor(this, this._childProcessors.size() - 1);
        }
    }

    public int getChildProcessorSize() {
        this.checkTimestamps();
        return this._childProcessors.size();
    }

    public ProcessorTreeWalker getChildProcessor(int index) {
        this.checkTimestamps();
        return (ProcessorTreeWalker)this._childProcessors.get(index);
    }

    public boolean isOnTemplate() {
        return true;
    }
}

