/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.error;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.maya.cycle.Response;
import org.seasar.maya.engine.Engine;
import org.seasar.maya.engine.Page;
import org.seasar.maya.engine.error.ErrorHandler;
import org.seasar.maya.impl.IllegalParameterValueException;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.cycle.CycleUtil;
import org.seasar.maya.impl.engine.PageNotFoundException;
import org.seasar.maya.impl.provider.ProviderUtil;
import org.seasar.maya.impl.util.StringUtil;

public class TemplateErrorHandler
extends ParameterAwareImpl
implements ErrorHandler {
    private static final Log LOG;
    private String _folder = "/";
    private String _extension = "html";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.maya.impl.engine.error.TemplateErrorHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    protected String getFolder() {
        return this._folder;
    }

    protected String getExtension() {
        return this._extension;
    }

    protected String getPageName(Class throwableClass) {
        if (throwableClass == null) {
            throw new IllegalArgumentException();
        }
        String name = throwableClass.getName();
        return String.valueOf(StringUtil.preparePath(this.getFolder())) + StringUtil.preparePath(name);
    }

    public void doErrorHandle(Throwable t, boolean pageFlush) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        Class<?> throwableClass = t.getClass();
        while (throwableClass != null) {
            String pageName = this.getPageName(throwableClass);
            try {
                Engine engine = ProviderUtil.getEngine();
                Page page = engine.getPage(pageName);
                page.doPageRender("", this.getExtension());
                if (LOG.isErrorEnabled()) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.seasar.maya.impl.engine.error.TemplateErrorHandler");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    String msg = StringUtil.getMessage((Class)clazz, 1, t.getMessage());
                    LOG.error((Object)msg, t);
                }
                if (!pageFlush) break;
                Response response = CycleUtil.getResponse();
                response.flush();
                break;
            }
            catch (PageNotFoundException ignore) {
                if (LOG.isInfoEnabled()) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.seasar.maya.impl.engine.error.TemplateErrorHandler");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    String msg = StringUtil.getMessage((Class)clazz, 2, pageName);
                    LOG.info((Object)msg);
                }
                throwableClass = throwableClass.getSuperclass();
            }
        }
    }

    public void setParameter(String name, String value) {
        if ("folder".equals(name)) {
            if (StringUtil.isEmpty(value)) {
                throw new IllegalParameterValueException(this.getClass(), name);
            }
            this._folder = value;
        } else if ("extension".equals(name)) {
            if (StringUtil.isEmpty(value)) {
                throw new IllegalParameterValueException(this.getClass(), name);
            }
            this._extension = value;
        }
        super.setParameter(name, value);
    }
}

